/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.ArrayList;
import java.util.List;
import org.geotools.data.FeatureListener;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentEntry;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class ContentState {
    protected Transaction tx;
    protected SimpleFeatureType featureType;
    protected int count = -1;
    protected ReferencedEnvelope bounds;
    protected ContentEntry entry;
    protected List<FeatureListener> listeners;

    public ContentState(ContentEntry entry) {
        this.entry = entry;
        this.listeners = new ArrayList<FeatureListener>(2);
    }

    protected ContentState(ContentState state) {
        this(state.getEntry());
        this.featureType = state.featureType;
        this.count = state.count;
        this.bounds = state.bounds == null ? null : new ReferencedEnvelope(state.bounds);
    }

    public ContentEntry getEntry() {
        return this.entry;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public final SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public final void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int count) {
        this.count = count;
    }

    public final ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public final void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    public final void addListener(FeatureListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(FeatureListener listener) {
        this.listeners.remove(listener);
    }

    public void flush() {
        this.featureType = null;
        this.count = -1;
        this.bounds = null;
    }

    public void close() {
        this.featureType = null;
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public ContentState copy() {
        return new ContentState(this);
    }
}

