/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.ows.kvp.TimeKvpParser;

public class TimeKvpParserTest
extends TestCase {
    private static final String PERIOD = "2007-01-01T12Z/2007-01-31T12Z/P1DT12H";
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH'Z'");

    public void testPeriod() throws ParseException {
        long millisInDay = 86400000L;
        TimeKvpParserTest.assertEquals((long)86400000L, (long)TimeKvpParser.parsePeriod((String)"P1D"));
        TimeKvpParserTest.assertEquals((long)259200000L, (long)TimeKvpParser.parsePeriod((String)"P3D"));
        TimeKvpParserTest.assertEquals((long)1209600000L, (long)TimeKvpParser.parsePeriod((String)"P2W"));
        TimeKvpParserTest.assertEquals((long)691200000L, (long)TimeKvpParser.parsePeriod((String)"P1W1D"));
        TimeKvpParserTest.assertEquals((long)86400000L, (long)TimeKvpParser.parsePeriod((String)"PT24H"));
        TimeKvpParserTest.assertEquals((long)Math.round(1.296E8), (long)TimeKvpParser.parsePeriod((String)"P1.5D"));
    }

    public void testInterval() throws ParseException {
        TimeKvpParser timeKvpParser = new TimeKvpParser("TIME");
        List l = (List)timeKvpParser.parse(PERIOD);
        TimeKvpParserTest.assertFalse((boolean)l.isEmpty());
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-01T12Z"), l.get(0));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-03T00Z"), l.get(1));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-04T12Z"), l.get(2));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-06T00Z"), l.get(3));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-07T12Z"), l.get(4));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-09T00Z"), l.get(5));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-10T12Z"), l.get(6));
        TimeKvpParserTest.assertEquals((Object)format.parse("2007-01-12T00Z"), l.get(7));
    }
}

