/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.Name;
import javax.sql.DataSource;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.StrictHints;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hints
extends RenderingHints {
    private static final Hints GLOBAL = new Hints();
    private static boolean needScan = true;
    public static final ClassKey CRS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSAuthorityFactory");
    public static final ClassKey CS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.cs.CSAuthorityFactory");
    public static final ClassKey DATUM_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumAuthorityFactory");
    public static final ClassKey CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
    public static final ClassKey CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
    public static final ClassKey DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
    public static final ClassKey COORDINATE_OPERATION_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationFactory");
    public static final ClassKey COORDINATE_OPERATION_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationAuthorityFactory");
    public static final ClassKey MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
    public static final Key DEFAULT_COORDINATE_REFERENCE_SYSTEM = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final FileKey CRS_AUTHORITY_EXTRA_DIRECTORY = new FileKey(false);
    public static final Key EPSG_DATA_SOURCE = new DataSourceKey();
    public static final OptionKey DATUM_SHIFT_METHOD = new OptionKey("Molodenski", "Abridged_Molodenski", "Geocentric", "*");
    public static final Key LENIENT_DATUM_SHIFT = new Key(Boolean.class);
    public static final Key FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Key(Boolean.class);
    public static final Key FORCE_AXIS_ORDER_HONORING = new Key(String.class);
    public static final Key FORCE_STANDARD_AXIS_DIRECTIONS = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_UNITS = new Key(Boolean.class);
    public static final Key VERSION = new Key("org.geotools.util.Version");
    public static final Key CRS = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final Key PRECISION = new Key("org.opengis.geometry.Precision");
    public static final Key POSITION_FACTORY = new Key("org.opengis.geometry.PositionFactory");
    public static final Key GEOMETRY_FACTORY = new Key("org.opengis.geometry.coordinate.GeometryFactory");
    public static final Key COMPLEX_FACTORY = new Key("org.opengis.geometry.complex.ComplexFactory");
    public static final Key AGGREGATE_FACTORY = new Key("org.opengis.geometry.aggregate.AggregateFactory");
    public static final Key PRIMITIVE_FACTORY = new Key("org.opengis.geometry.primitive.PrimitiveFactory");
    public static final Key GEOMETRY_VALIDATE = new Key(Boolean.class);
    public static final ClassKey JTS_GEOMETRY_FACTORY = new ClassKey("com.vividsolutions.jts.geom.GeometryFactory");
    public static final ClassKey JTS_COORDINATE_SEQUENCE_FACTORY = new ClassKey("com.vividsolutions.jts.geom.CoordinateSequenceFactory");
    public static final Key JTS_PRECISION_MODEL = new Key("com.vividsolutions.jts.geom.PrecisionModel");
    public static final Key JTS_SRID = new Key(Integer.class);
    public static ClassKey FEATURE_FACTORY = new ClassKey("org.opengis.feature.FeatureFactory");
    public static ClassKey FEATURE_TYPE_FACTORY = new ClassKey("org.opengis.feature.type.FeatureTypeFactory");
    public static final ClassKey FEATURE_LOCK_FACTORY = new ClassKey("org.geotools.data.FeatureLockFactory");
    public static final ClassKey FEATURE_COLLECTIONS = new ClassKey("org.geotools.feature.FeatureCollections");
    public static final Key FEATURE_TYPE_FACTORY_NAME = new Key(String.class);
    public static final Key FEATURE_DETACHED = new Key(Boolean.class);
    public static final Key FEATURE_2D = new Key(Boolean.class);
    public static final Key GEOMETRY_DISTANCE = new Key(Double.class);
    public static final Key GEOMETRY_GENERALIZATION = new Key(Double.class);
    public static final Key GEOMETRY_SIMPLIFICATION = new Key(Double.class);
    public static final ClassKey STYLE_FACTORY = new ClassKey("org.geotools.styling.StyleFactory");
    public static final ClassKey ATTRIBUTE_TYPE_FACTORY = new ClassKey("org.geotools.feature.AttributeTypeFactory");
    public static final ClassKey FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
    public static final Key GRID_COVERAGE_PROCESSOR = new Key(Object.class);
    public static final Key IGNORE_COVERAGE_OVERVIEW = new Key(Boolean.class);
    public static final Key MAX_ALLOWED_TILES = new Key(Integer.class);
    public static final Key MOSAIC_LOCATION_ATTRIBUTE = new Key(String.class);
    public static final Key USE_JAI_IMAGEREAD = new Key(Boolean.class);
    public static Object VALUE_OVERVIEW_POLICY_QUALITY;
    public static Object VALUE_OVERVIEW_POLICY_IGNORE;
    public static Object VALUE_OVERVIEW_POLICY_NEAREST;
    public static Object VALUE_OVERVIEW_POLICY_SPEED;
    public static final Key OVERVIEW_POLICY;
    public static final Key COVERAGE_PROCESSING_VIEW;
    public static final Key REPLACE_NON_GEOPHYSICS_VIEW;
    public static final Key TILE_ENCODING;
    public static final Key JAI_INSTANCE;
    public static final Key SAMPLE_DIMENSION_TYPE;
    public static final Key ASSOCIATION_TRAVERSAL_DEPTH;
    public static final Key ASSOCIATION_PROPERTY;
    public static final OptionKey CACHE_POLICY;
    public static final IntegerKey CACHE_LIMIT;
    public static final IntegerKey AUTHORITY_MAX_ACTIVE;
    public static final IntegerKey AUTHORITY_MIN_IDLE;
    public static final IntegerKey AUTHORITY_MAX_IDLE;
    public static final IntegerKey AUTHORITY_MIN_EVICT_IDLETIME;
    public static final IntegerKey AUTHORITY_SOFTMIN_EVICT_IDLETIME;
    public static final IntegerKey AUTHORITY_TIME_BETWEEN_EVICTION_RUNS;

    public Hints() {
        super(null);
    }

    public Hints(RenderingHints.Key key, Object value) {
        super(null);
        super.put(key, value);
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2) {
        this(key1, value1);
        super.put(key2, value2);
    }

    @Deprecated
    public Hints(RenderingHints.Key key1, Object value1, Object[] pairs) {
        this(key1, value1);
        this.fromPairs(pairs);
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2, Object ... pairs) {
        this(key1, value1, key2, value2);
        this.fromPairs(pairs);
    }

    private void fromPairs(Object[] pairs) throws IllegalArgumentException {
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format(109, pairs.length));
        }
        for (int i = 0; i < pairs.length; i += 2) {
            super.put(pairs[i], pairs[i + 1]);
        }
    }

    public Hints(Map<? extends RenderingHints.Key, ?> hints) {
        super(Hints.stripNonKeys(hints));
    }

    public Hints(RenderingHints hints) {
        super(Hints.stripNonKeys(hints));
    }

    static Map<RenderingHints.Key, Object> stripNonKeys(Map<?, ?> hints) {
        if (hints == null) {
            return null;
        }
        Map<RenderingHints.Key, Object> filtered = hints;
        for (Object key : hints.keySet()) {
            if (key instanceof RenderingHints.Key) continue;
            if (filtered == hints) {
                filtered = new HashMap<RenderingHints.Key, Object>(filtered);
            }
            filtered.remove(key);
        }
        return filtered;
    }

    @Override
    public Hints clone() {
        return (Hints)super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanSystemProperties() {
        Hints hints = GLOBAL;
        synchronized (hints) {
            needScan = true;
        }
    }

    private static boolean ensureSystemDefaultLoaded() {
        assert (Thread.holdsLock(GLOBAL));
        if (needScan) {
            needScan = false;
            return GeoTools.scanForSystemHints(GLOBAL);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hints getDefaults(boolean strict) {
        Hints hints;
        boolean changed;
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            changed = Hints.ensureSystemDefaultLoaded();
            hints = strict ? new StrictHints(GLOBAL) : new Hints(GLOBAL);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putSystemDefault(RenderingHints hints) {
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            Hints.ensureSystemDefaultLoaded();
            GLOBAL.add(hints);
        }
        GeoTools.fireConfigurationChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSystemDefault(RenderingHints.Key key) {
        Object value;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            value = GLOBAL.get(key);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putSystemDefault(RenderingHints.Key key, Object value) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.put(key, value);
        }
        if (changed || !Utilities.equals(value, old)) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object removeSystemDefault(RenderingHints.Key key) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.remove(key);
        }
        if (changed || old != null) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        boolean changed;
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder buffer = new StringBuilder("Hints:");
        buffer.append(lineSeparator).append(AbstractFactory.toString(this));
        HashMap<Object, Object> extra = null;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            if (!GLOBAL.isEmpty()) {
                extra = new HashMap<Object, Object>(GLOBAL);
            }
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        if (extra != null) {
            extra.keySet().removeAll(this.keySet());
            if (!extra.isEmpty()) {
                buffer.append("System defaults:").append(lineSeparator).append(AbstractFactory.toString(extra));
            }
        }
        return buffer.toString();
    }

    static String nameOf(RenderingHints.Key key) {
        String name;
        if (key instanceof Key) {
            return key.toString();
        }
        int t = 0;
        block7: while (true) {
            Class type;
            switch (t++) {
                case 0: {
                    type = RenderingHints.class;
                    break;
                }
                case 1: {
                    try {
                        type = Class.forName("javax.media.jai.JAI");
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        continue block7;
                    }
                    catch (NoClassDefFoundError e) {
                        continue block7;
                    }
                }
                default: {
                    return key.toString();
                }
            }
            if ((name = Hints.nameOf(type, key)) != null) break;
        }
        return name;
    }

    private static String nameOf(Class<?> type, RenderingHints.Key key) {
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object v;
            Field f = fields[i];
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                v = f.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (v != key) continue;
            return f.getName();
        }
        return null;
    }

    static {
        try {
            Class<?> c = Class.forName("org.geotools.coverage.grid.io.OverviewPolicy");
            VALUE_OVERVIEW_POLICY_QUALITY = c.getField("QUALITY").get(null);
            VALUE_OVERVIEW_POLICY_IGNORE = c.getField("IGNORE").get(null);
            VALUE_OVERVIEW_POLICY_NEAREST = c.getField("NEAREST").get(null);
            VALUE_OVERVIEW_POLICY_SPEED = c.getField("SPEED").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OVERVIEW_POLICY = new Key("org.geotools.coverage.grid.io.OverviewPolicy");
        COVERAGE_PROCESSING_VIEW = new Key("org.geotools.coverage.grid.ViewType");
        REPLACE_NON_GEOPHYSICS_VIEW = new Key(Boolean.class);
        TILE_ENCODING = new Key(String.class);
        JAI_INSTANCE = new Key("javax.media.jai.JAI");
        SAMPLE_DIMENSION_TYPE = new Key("org.opengis.coverage.SampleDimensionType");
        ASSOCIATION_TRAVERSAL_DEPTH = new Key(Integer.class);
        ASSOCIATION_PROPERTY = new Key("org.opengis.filter.expression.PropertyName");
        CACHE_POLICY = new OptionKey("weak", "all", "fixed", "none", "default");
        CACHE_LIMIT = new IntegerKey(50);
        AUTHORITY_MAX_ACTIVE = new IntegerKey(Runtime.getRuntime().availableProcessors() + 1);
        AUTHORITY_MIN_IDLE = new IntegerKey(1);
        AUTHORITY_MAX_IDLE = new IntegerKey(2);
        AUTHORITY_MIN_EVICT_IDLETIME = new IntegerKey(120000);
        AUTHORITY_SOFTMIN_EVICT_IDLETIME = new IntegerKey(10000);
        AUTHORITY_TIME_BETWEEN_EVICTION_RUNS = new IntegerKey(5000);
    }

    static final class DataSourceKey
    extends Key {
        public DataSourceKey() {
            super(DataSource.class);
        }

        public boolean isCompatibleValue(Object value) {
            return value instanceof DataSource || value instanceof String || value instanceof Name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OptionKey
    extends Key {
        private final Set<String> options;
        private final boolean wildcard;

        public OptionKey(String ... alternatives) {
            super(String.class);
            TreeSet<String> options = new TreeSet<String>(Arrays.asList(alternatives));
            this.wildcard = options.remove("*");
            this.options = Collections.unmodifiableSet(options);
        }

        public Set<String> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            return this.wildcard ? value instanceof String : this.options.contains(value);
        }
    }

    public static final class IntegerKey
    extends Key {
        private final int number;

        public IntegerKey(int number) {
            super(Integer.class);
            this.number = number;
        }

        public int getDefault() {
            return this.number;
        }

        public int toValue(Hints hints) {
            if (hints != null) {
                Object value = hints.get(this);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof CharSequence) {
                    return Integer.parseInt(value.toString());
                }
            }
            return this.number;
        }

        public boolean isCompatibleValue(Object value) {
            if (value instanceof Short || value instanceof Integer) {
                return true;
            }
            if (value instanceof String || value instanceof InternationalString) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    Logging.getLogger(IntegerKey.class).finer(e.toString());
                }
            }
            return false;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean writable) {
            super(File.class);
            this.writable = writable;
        }

        public boolean isCompatibleValue(Object value) {
            File file;
            if (value instanceof File) {
                file = (File)value;
            } else if (value instanceof String) {
                file = new File((String)value);
            } else {
                return false;
            }
            if (file.exists()) {
                return !this.writable || file.canWrite();
            }
            File parent = file.getParentFile();
            return parent != null && parent.canWrite();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassKey
    extends Key {
        public ClassKey(Class<?> classe) {
            super(classe);
        }

        ClassKey(String className) {
            super(className);
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Class[]) {
                Class[] types = (Class[])value;
                for (int i = 0; i < types.length; ++i) {
                    if (this.isCompatibleValue(types[i])) continue;
                    return false;
                }
                return types.length != 0;
            }
            if (value instanceof Class) {
                int modifiers;
                Class type = (Class)value;
                Class<?> expected = this.getValueClass();
                if (expected.isAssignableFrom(type)) {
                    return true;
                }
                return expected.isInterface() && !type.isInterface() && Modifier.isAbstract(modifiers = type.getModifiers()) && !Modifier.isFinal(modifiers);
            }
            return super.isCompatibleValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends RenderingHints.Key {
        private static int count;
        private final String className;
        private transient Class<?> valueClass;

        public Key(Class<?> classe) {
            this(classe.getName());
            this.valueClass = classe;
        }

        Key(String className) {
            super(Key.count());
            this.className = className;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class<?> getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException exception) {
                    Logging.unexpectedException(Key.class, "getValueClass", exception);
                    this.valueClass = Object.class;
                }
            }
            return this.valueClass;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            return this.getValueClass().isInstance(value);
        }

        public String toString() {
            Class type;
            String name;
            int t = 0;
            do {
                switch (t++) {
                    case 0: {
                        type = Hints.class;
                        break;
                    }
                    case 1: {
                        type = this.getValueClass();
                        break;
                    }
                    default: {
                        return super.toString();
                    }
                }
            } while ((name = Hints.nameOf(type, this)) == null);
            return name;
        }
    }
}

