/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WCSDTO;

public final class WCS
extends Service {
    public static final String WEB_CONTAINER_KEY = "WCS";
    private static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage", "application/vnd.ogc.se_blank"};
    WCSInfo wcs;

    public WCS(GeoServer gs) {
        super(gs.getService(WCSInfo.class), gs);
        this.init();
    }

    public WCSInfo getInfo() {
        return this.wcs;
    }

    public void init() {
        this.wcs = (WCSInfo)this.gs.getService(WCSInfo.class);
        this.service = this.wcs;
    }

    public void load(WCSDTO config) {
        super.load(config.getService());
        this.setGmlPrefixing(config.isGmlPrefixing());
        this.gs.save((ServiceInfo)this.wcs);
    }

    public WCSDTO toDTO() {
        WCSDTO dto = new WCSDTO();
        dto.setService((ServiceDTO)super.toDTO());
        dto.setGmlPrefixing(this.isGmlPrefixing());
        return dto;
    }

    public boolean isGmlPrefixing() {
        return this.wcs.isGMLPrefixing();
    }

    public void setGmlPrefixing(boolean b) {
        this.wcs.setGMLPrefixing(b);
    }

    public String[] getExceptionFormats() {
        return EXCEPTION_FORMATS;
    }
}

