/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Compactor {
    private static final Pattern uselessExponentPattern = Pattern.compile("([\\(\\,]\\-?\\d+\\.\\d+)E[\\+\\-]?0+([\\,\\)])");

    private Compactor() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader("EPSG.sql"));
        BufferedWriter out = new BufferedWriter(new FileWriter("EPSG-compact.sql"));
        String lineSeparator = System.getProperty("line.separator", "\n");
        boolean insertDatum = false;
        String insertStatement = null;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (insertStatement != null) {
                if (line.startsWith(insertStatement)) {
                    line = line.substring(insertStatement.length()).trim();
                    line = Compactor.removeUselessExponents(line);
                    if (insertDatum) {
                        line = Compactor.removeRealizationEpochQuotes(line);
                    }
                    out.write(44);
                    out.write(lineSeparator);
                    out.write(line);
                    continue;
                }
                out.write(lineSeparator);
            }
            if (line.startsWith("INSERT INTO")) {
                insertDatum = line.startsWith("INSERT INTO EPSG_DATUM VALUES");
                int values = line.indexOf("VALUES", 11);
                if (values >= 0) {
                    insertStatement = line.substring(0, values += 6).trim();
                    line = line.substring(insertStatement.length()).trim();
                    line = Compactor.removeUselessExponents(line);
                    if (insertDatum) {
                        line = Compactor.removeRealizationEpochQuotes(line);
                    }
                    out.write(insertStatement);
                    out.write(lineSeparator);
                    out.write(line);
                    continue;
                }
            }
            insertStatement = null;
            out.write(line);
            out.write(lineSeparator);
        }
        out.close();
        in.close();
    }

    private static String removeUselessExponents(String line) {
        StringBuilder cleaned = null;
        Matcher matcher = uselessExponentPattern.matcher(line);
        while (true) {
            int lastIndex = 0;
            while (matcher.find()) {
                boolean quoted = false;
                int i = matcher.start();
                while ((i = line.lastIndexOf(39, i - 1)) >= 0) {
                    if (i != 0 && line.charAt(i - 1) == '\\') continue;
                    quoted = !quoted;
                }
                if (quoted) continue;
                if (cleaned == null) {
                    cleaned = new StringBuilder();
                }
                cleaned.append(line.substring(lastIndex, matcher.end(1)));
                lastIndex = matcher.end();
                cleaned.append(line.substring(matcher.start(2), lastIndex));
            }
            if (lastIndex == 0) {
                return line;
            }
            cleaned.append(line.substring(lastIndex));
            line = cleaned.toString();
            matcher.reset(line);
            cleaned.setLength(0);
        }
    }

    private static String removeRealizationEpochQuotes(String line) {
        int index = Compactor.getIndexForColumn(line, 5);
        if (line.charAt(index) != '\'') {
            return line;
        }
        StringBuilder cleaned = new StringBuilder(line.substring(0, index));
        if (line.charAt(++index) == '\'') {
            cleaned.append("NULL");
        } else {
            do {
                cleaned.append(line.charAt(index));
            } while (line.charAt(++index) != '\'');
        }
        cleaned.append(line.substring(index + 1));
        return cleaned.toString();
    }

    private static int getIndexForColumn(String line, int column) {
        if (--column == 0) {
            return 0;
        }
        boolean quote = false;
        int length = line.length();
        block4: for (int index = 0; index < length; ++index) {
            switch (line.charAt(index)) {
                case '\'': {
                    if (index != 0 && line.charAt(index - 1) == '\\') continue block4;
                    quote = !quote;
                    continue block4;
                }
                case ',': {
                    if (quote || --column != 0) continue block4;
                    return index + 1;
                }
            }
        }
        return length;
    }
}

