/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.io.IOException;
import java.io.InputStream;
import org.restlet.resource.Representation;
import org.springframework.core.io.AbstractResource;

public class SpringResource
extends AbstractResource {
    private final Representation representation;
    private final String description;
    private boolean read = false;

    public SpringResource(Representation representation) {
        this(representation, "Resource loaded through a Representation");
    }

    public SpringResource(Representation representation, String description) {
        if (representation == null) {
            throw new IllegalArgumentException("Representation must not be null");
        }
        this.representation = representation;
        this.description = description != null ? description : "";
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return true;
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read && this.representation.isTransient()) {
            throw new IllegalStateException("Representation has already been read and is transient.");
        }
        this.read = true;
        return this.representation.getStream();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpringResource && ((SpringResource)((Object)obj)).representation.equals(this.representation);
    }

    public int hashCode() {
        return this.representation.hashCode();
    }
}

