/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
    }

    public List build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        Iterator nodeit = this.op.getGraph().getNodes().iterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).findCoveredLineEdges();
        }
        Iterator it = this.op.getGraph().getEdgeEnds().iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Edge e = de.getEdge();
            if (!de.isLineEdge() || e.isCoveredSet()) continue;
            boolean isCovered = this.op.isCoveredByA(de.getCoordinate());
            e.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        Iterator it = this.op.getGraph().getEdgeEnds().iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            this.collectLineEdge(de, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de, opCode, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        Edge e = de.getEdge();
        if (de.isLineEdge() && !de.isVisited() && OverlayOp.isResultOfOp(label, opCode) && !e.isCovered()) {
            edges.add(e);
            de.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        if (de.isLineEdge()) {
            return;
        }
        if (de.isVisited()) {
            return;
        }
        if (de.isInteriorAreaEdge()) {
            return;
        }
        if (de.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!de.isInResult() && !de.getSym().isInResult() || !de.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label, opCode) && opCode == 1) {
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        Iterator it = this.lineEdgesList.iterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Label label = e.getLabel();
            LineString line = this.geometryFactory.createLineString(e.getCoordinates());
            this.resultLineList.add(line);
            e.setInResult(true);
        }
    }

    private void labelIsolatedLines(List edgesList) {
        Iterator it = edgesList.iterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Label label = e.getLabel();
            if (!e.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedLine(e, 0);
                continue;
            }
            this.labelIsolatedLine(e, 1);
        }
    }

    private void labelIsolatedLine(Edge e, int targetIndex) {
        int loc = this.ptLocator.locate(e.getCoordinate(), this.op.getArgGeometry(targetIndex));
        e.getLabel().setLocation(targetIndex, loc);
    }
}

