/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response.v1_1_0;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.response.v1_1_0.WFS11Response;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class FeatureResponse
extends WFS11Response {
    Data catalog;
    WFSConfiguration configuration;
    private WFS wfs;

    public FeatureResponse(Data catalog, WFSConfiguration configuration, WFS wfs) {
        super(SimpleFeature.class);
        this.catalog = catalog;
        this.configuration = configuration;
        this.wfs = wfs;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml; subtype=gml/3.1.1";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        SimpleFeature feature = (SimpleFeature)value;
        SimpleFeatureType featureType = feature.getType();
        FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(featureType.getName());
        Encoder encoder = new Encoder((Configuration)this.configuration);
        encoder.setEncoding(this.wfs.getCharSet());
        encoder.encode((Object)feature, new QName(meta.getNameSpace().getURI(), meta.getTypeName()), output);
    }
}

