/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.config.GeoServer;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WFSDTO;

public class WFS
extends Service {
    public static final String WEB_CONTAINER_KEY = "WFS";
    public static final int SERVICE_BASIC = 1;
    public static final int SERVICE_INSERT = 2;
    public static final int SERVICE_UPDATE = 4;
    public static final int SERVICE_DELETE = 8;
    public static final int SERVICE_LOCKING = 16;
    public static final int BASIC = WFSInfo.ServiceLevel.BASIC.getCode();
    public static final int TRANSACTIONAL = WFSInfo.ServiceLevel.TRANSACTIONAL.getCode();
    public static final int COMPLETE = WFSInfo.ServiceLevel.COMPLETE.getCode();
    WFSInfo wfs;

    public WFS(GeoServer gs) {
        super(gs.getService(WFSInfo.class), gs);
        this.init();
    }

    public void init() {
        this.wfs = (WFSInfo)this.gs.getService(WFSInfo.class);
        this.service = this.wfs;
    }

    public WFSInfo getInfo() {
        return this.wfs;
    }

    public void load(WFSDTO config) {
        super.load(config.getService());
        this.setSrsXmlStyle(config.isSrsXmlStyle());
        this.setServiceLevel(config.getServiceLevel());
        this.setCiteConformanceHacks(config.getCiteConformanceHacks());
        this.setFeatureBounding(config.isFeatureBounding());
    }

    public WFSDTO toDTO() {
        WFSDTO dto = new WFSDTO();
        dto.setService((ServiceDTO)super.toDTO());
        dto.setServiceLevel(this.getServiceLevel());
        dto.setSrsXmlStyle(this.isSrsXmlStyle());
        dto.setCiteConformanceHacks(this.getCiteConformanceHacks());
        dto.setFeatureBounding(this.isFeatureBounding());
        return dto;
    }

    public boolean isSrsXmlStyle() {
        GMLInfo gml = this.wfs.getGML().get((Object)WFSInfo.Version.V_10);
        return gml.getSrsNameStyle() == GMLInfo.SrsNameStyle.XML;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        GMLInfo gml = this.wfs.getGML().get((Object)WFSInfo.Version.V_10);
        if (doXmlStyle) {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.XML);
        } else {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.NORMAL);
        }
    }

    public String getSrsPrefix() {
        GMLInfo gml = this.wfs.getGML().get((Object)WFSInfo.Version.V_10);
        return gml.getSrsNameStyle().getPrefix();
    }

    public void setServiceLevel(int serviceLevel) {
        this.wfs.setServiceLevel(WFSInfo.ServiceLevel.get(serviceLevel));
    }

    public int getServiceLevel() {
        return this.wfs.getServiceLevel().getCode();
    }

    public void setCiteConformanceHacks(boolean on) {
        this.wfs.setCiteCompliant(on);
    }

    public boolean getCiteConformanceHacks() {
        return this.wfs.isCiteCompliant();
    }

    public boolean isFeatureBounding() {
        return this.wfs.getGML().get((Object)WFSInfo.Version.V_10).isFeatureBounding();
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.wfs.getGML().get((Object)WFSInfo.Version.V_10).setFeatureBounding(featureBounding);
    }
}

