/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingHSQL;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.hsqldb.jdbc.jdbcDataSource;

public class ThreadedHsqlEpsgFactory
extends ThreadedEpsgFactory {
    public static final Version VERSION = new Version("6.12.0");
    public static final String DIRECTORY_KEY = "EPSG-HSQL.directory";
    private static final String SQL_FILE = "EPSG.sql";
    public static final String DATABASE_NAME = "EPSG";
    private static final String PREFIX = "jdbc:hsqldb:file:";
    private static final String LOGGER = "org.geotools.referencing.factory.epsg";

    public ThreadedHsqlEpsgFactory() {
        this((Hints)null);
    }

    public ThreadedHsqlEpsgFactory(Hints hints) {
        super(hints, 91);
    }

    private static File getDirectory() {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ThreadedHsqlEpsgFactory.getTemporaryDirectory();
    }

    private static File getTemporaryDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/HSQL")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        return null;
    }

    private static File getDirectory(DataSource source) {
        String path;
        if (source instanceof jdbcDataSource && (path = ((jdbcDataSource)source).getDatabase()) != null && PREFIX.regionMatches(true, 0, path, 0, PREFIX.length())) {
            path = path.substring(PREFIX.length());
            return new File(path).getParentFile();
        }
        return null;
    }

    protected DataSource createDataSource() throws SQLException {
        DataSource candidate = super.createDataSource();
        if (candidate instanceof jdbcDataSource) {
            return candidate;
        }
        jdbcDataSource source = new jdbcDataSource();
        File directory = ThreadedHsqlEpsgFactory.getDirectory();
        if (directory != null) {
            StringBuilder url = new StringBuilder(PREFIX);
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append(DATABASE_NAME);
            source.setDatabase(url.toString());
            assert (directory.equals(ThreadedHsqlEpsgFactory.getDirectory((DataSource)source))) : url;
        }
        source.setUser("SA");
        return source;
    }

    private static boolean dataExists(Connection connection) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "EPSG_%", new String[]{"TABLE"});
        boolean exists = tables.next();
        tables.close();
        return exists;
    }

    private static void deleteIfOutdated(File directory, File propertyFile) {
        if (directory == null || !directory.equals(ThreadedHsqlEpsgFactory.getTemporaryDirectory())) {
            return;
        }
        if (propertyFile.isFile()) {
            try {
                FileInputStream propertyIn = new FileInputStream(propertyFile);
                Properties properties = new Properties();
                properties.load(propertyIn);
                ((InputStream)propertyIn).close();
                String version = properties.getProperty("epsg.version");
                if (version != null && new Version(version).compareTo(VERSION) >= 0) {
                    return;
                }
            }
            catch (IOException exception) {
                Logging.unexpectedException((String)LOGGER, ThreadedHsqlEpsgFactory.class, (String)"createBackingStore", (Throwable)exception);
            }
        }
        ThreadedHsqlEpsgFactory.delete(directory);
    }

    private static void delete(File directory) {
        if (directory != null) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ThreadedHsqlEpsgFactory.delete(files[i]);
                }
            }
            directory.delete();
        }
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        DataSource source = this.getDataSource();
        File directory = ThreadedHsqlEpsgFactory.getDirectory(source);
        File propertyFile = new File(directory, "EPSG.properties");
        ThreadedHsqlEpsgFactory.deleteIfOutdated(directory, propertyFile);
        Connection connection = source.getConnection();
        if (!ThreadedHsqlEpsgFactory.dataExists(connection)) {
            Logger logger = Logging.getLogger((String)LOGGER);
            LogRecord record = Loggings.format((Level)Level.INFO, (int)46, (Object)VERSION);
            record.setLoggerName(logger.getName());
            logger.log(record);
            Statement statement = connection.createStatement();
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(ThreadedHsqlEpsgFactory.class.getResourceAsStream(SQL_FILE), "ISO-8859-1"));
                StringBuilder insertStatement = null;
                while ((line = in.readLine()) != null) {
                    int length = (line = line.trim()).length();
                    if (length == 0) continue;
                    if (line.startsWith("INSERT INTO")) {
                        insertStatement = new StringBuilder(line);
                        continue;
                    }
                    if (insertStatement != null) {
                        boolean hasMore;
                        int values = insertStatement.length();
                        insertStatement.append(line);
                        boolean bl = hasMore = line.charAt(length - 1) == ',';
                        if (hasMore) {
                            insertStatement.setLength(insertStatement.length() - 1);
                        }
                        line = insertStatement.toString();
                        insertStatement.setLength(values);
                        if (!hasMore) {
                            insertStatement = null;
                        }
                    }
                    statement.execute(line);
                }
                in.close();
                if (directory != null) {
                    FileInputStream propertyIn = new FileInputStream(propertyFile);
                    Properties properties = new Properties();
                    properties.load(propertyIn);
                    ((InputStream)propertyIn).close();
                    properties.put("epsg.version", VERSION.toString());
                    properties.put("readonly", "true");
                    FileOutputStream out = new FileOutputStream(propertyFile);
                    properties.store(out, "EPSG database on HSQL");
                    ((OutputStream)out).close();
                    File backup = new File(directory, "EPSG.backup");
                    if (backup.exists()) {
                        backup.delete();
                    }
                }
            }
            catch (IOException exception) {
                statement.close();
                SQLException e = new SQLException(Errors.format((int)163, (Object)SQL_FILE));
                e.initCause(exception);
                throw e;
            }
            statement.close();
            connection.close();
            connection = source.getConnection();
            assert (ThreadedHsqlEpsgFactory.dataExists(connection));
        }
        return new FactoryUsingHSQL(hints, connection);
    }
}

