/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MemorySpatialIndex;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.imagemosaic");
    private final URL sourceURL;
    private final AbstractDataStore tileIndexStore;
    private SoftReference<MemorySpatialIndex> index;
    private final String typeName;
    private final FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    private boolean expandMe;
    private boolean absolutePath;
    private int maxAllowedTiles = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    private String locationAttributeName;

    public int getGridCoverageCount() {
        return 1;
    }

    public synchronized void dispose() {
        block2: {
            super.dispose();
            try {
                this.tileIndexStore.dispose();
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        Object tempCRS;
        String[] typeNames;
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)Hints.MAX_ALLOWED_TILES)) {
            this.maxAllowedTiles = (Integer)this.hints.get((Object)Hints.MAX_ALLOWED_TILES);
        }
        if (this.hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
            this.locationAttributeName = (String)this.hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
        }
        if (source == null) {
            IOException ex = new IOException("ImageMosaicReader:No source set to read this coverage.");
            if (!LOGGER.isLoggable(Level.WARNING)) throw new DataSourceException(ex);
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            throw new DataSourceException(ex);
        }
        this.source = source;
        if (source instanceof File) {
            this.sourceURL = ((File)source).toURL();
        } else if (source instanceof URL) {
            this.sourceURL = (URL)source;
        } else {
            if (!(source instanceof String)) throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a file");
            File tempFile = new File((String)source);
            if (tempFile.exists()) {
                this.sourceURL = tempFile.toURL();
            } else {
                try {
                    this.sourceURL = new URL(URLDecoder.decode((String)source, "UTF8"));
                    if (this.sourceURL.getProtocol() != "file") {
                        throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    }
                }
                catch (MalformedURLException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    throw new IllegalArgumentException("This plugin accepts only File,  URL and String pointing to a file");
                }
            }
        }
        this.tileIndexStore = new ShapefileDataStore(this.sourceURL);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Connected mosaic reader to its data store " + this.sourceURL.toString());
        }
        if ((typeNames = this.tileIndexStore.getTypeNames()).length <= 0) {
            throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
        }
        this.typeName = typeNames[0];
        this.featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
        SimpleFeatureType schema = this.featureSource.getSchema();
        if (this.locationAttributeName == null) {
            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                if (!attribute.getType().getBinding().equals(String.class)) continue;
                this.locationAttributeName = attribute.getName().toString();
            }
        }
        if (schema.getDescriptor(this.locationAttributeName) == null) {
            throw new DataSourceException("The provided name for the location attribute is invalid.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to create index");
        }
        this.index = new SoftReference<MemorySpatialIndex>(new MemorySpatialIndex(this.featureSource.getFeatures()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created index");
        }
        if ((tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM)) != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, new StringBuffer("Using forced coordinate reference system ").append(this.crs.toWKT()).toString());
        } else {
            CoordinateReferenceSystem tempcrs = this.featureSource.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, new StringBuffer("Unable to find a CRS for this coverage, using a default one: ").append(this.crs.toWKT()).toString());
            } else {
                this.crs = tempcrs;
            }
        }
        this.loadProperties();
    }

    private void loadProperties() throws UnsupportedEncodingException, IOException, FileNotFoundException {
        String[] pair;
        File propertiesFile;
        String temp = URLDecoder.decode(this.sourceURL.getFile(), "UTF8");
        int index = temp.lastIndexOf(".");
        if (index != -1) {
            temp = temp.substring(0, index);
        }
        if (!(propertiesFile = new File(new StringBuffer(temp).append(".properties").toString())).exists() || !propertiesFile.isFile()) {
            throw new FileNotFoundException("Properties file, descibing the ImageMoasic, does not exist:" + propertiesFile);
        }
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
        String envelope = properties.getProperty("Envelope2D");
        String[] pairs = envelope.split(" ");
        double[][] cornersV = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            pair = pairs[i].split(",");
            cornersV[i][0] = Double.parseDouble(pair[0]);
            cornersV[i][1] = Double.parseDouble(pair[1]);
        }
        this.originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
        String levels = properties.getProperty("Levels");
        pairs = levels.split(" ");
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        pair = pairs[0].split(",");
        this.highestRes = new double[2];
        this.highestRes[0] = Double.parseDouble(pair[0]);
        this.highestRes[1] = Double.parseDouble(pair[1]);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        for (int i = 1; i < this.numOverviews + 1; ++i) {
            pair = pairs[i].split(",");
            this.overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
            this.overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
        }
        this.coverageName = properties.getProperty("Name");
        try {
            this.expandMe = properties.getProperty("ExpandToRGB").equalsIgnoreCase("true");
        }
        catch (Throwable t) {
            this.expandMe = false;
        }
        this.originalGridRange = new GeneralGridRange(new Rectangle((int)Math.round(this.originalEnvelope.getLength(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getLength(1) / this.highestRes[1])));
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)this.originalGridRange, this.originalEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        this.raster2Model = geMapper.createTransform();
        this.absolutePath = Boolean.parseBoolean(properties.getProperty("", "False"));
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        Color inputTransparentColor = (Color)ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
        Color outputTransparentColor = (Color)ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
        double inputImageThreshold = (Double)ImageMosaicFormat.INPUT_IMAGE_THRESHOLD_VALUE.getDefaultValue();
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        boolean blend = false;
        int maxNumTiles = this.maxAllowedTiles;
        OverviewPolicy overviewPolicy = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(ImageMosaicFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = (GeneralEnvelope)gg.getEnvelope();
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (name.equals(ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getName().toString())) {
                    inputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (name.equals(ImageMosaicFormat.INPUT_IMAGE_THRESHOLD_VALUE.getName().toString())) {
                    inputImageThreshold = (Double)param.getValue();
                    continue;
                }
                if (name.equals(ImageMosaicFormat.FADING.getName().toString())) {
                    blend = (Boolean)param.getValue();
                    continue;
                }
                if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName().toString())) {
                    outputTransparentColor = (Color)param.getValue();
                    continue;
                }
                if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) {
                    overviewPolicy = (OverviewPolicy)param.getValue();
                    continue;
                }
                if (!name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString())) continue;
                maxNumTiles = param.intValue();
            }
        }
        return this.loadTiles(requestedEnvelope, inputTransparentColor, outputTransparentColor, inputImageThreshold, dim, blend, overviewPolicy, maxNumTiles);
    }

    private GridCoverage loadTiles(GeneralEnvelope requestedOriginalEnvelope, Color transparentColor, Color outputTransparentColor, double inputImageThresholdValue, Rectangle pixelDimension, boolean fading, OverviewPolicy overviewPolicy, int maxNumTiles) throws IOException {
        List<SimpleFeature> features;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Creating mosaic to comply with envelope ").append(requestedOriginalEnvelope != null ? requestedOriginalEnvelope.toString() : null).append(" crs ").append(this.crs.toWKT()).append(" dim ").append(pixelDimension == null ? " null" : pixelDimension.toString()).toString());
        }
        GeneralEnvelope intersectionEnvelope = null;
        if (requestedOriginalEnvelope != null) {
            if (!CRS.equalsIgnoreMetadata(requestedOriginalEnvelope.getCoordinateReferenceSystem(), this.crs)) {
                try {
                    MathTransform transform = CRS.findMathTransform(requestedOriginalEnvelope.getCoordinateReferenceSystem(), this.crs, true);
                    if (!transform.isIdentity()) {
                        requestedOriginalEnvelope = CRS.transform(transform, (org.opengis.geometry.Envelope)requestedOriginalEnvelope);
                        requestedOriginalEnvelope.setCoordinateReferenceSystem(this.crs);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(new StringBuffer("Reprojected envelope ").append(requestedOriginalEnvelope.toString()).append(" crs ").append(this.crs.toWKT()).toString());
                        }
                    }
                }
                catch (TransformException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", e);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", e);
                }
            }
            if (!requestedOriginalEnvelope.intersects(this.originalEnvelope, true)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The requested envelope does not intersect the envelope of this mosaic, we will return a null coverage.");
                }
                throw new DataSourceException("Unable to create a coverage for this source");
            }
            intersectionEnvelope = new GeneralEnvelope(requestedOriginalEnvelope);
            intersectionEnvelope.intersect(this.originalEnvelope);
        } else {
            intersectionEnvelope = requestedOriginalEnvelope = new GeneralEnvelope(this.originalEnvelope);
        }
        requestedOriginalEnvelope.setCoordinateReferenceSystem(this.crs);
        intersectionEnvelope.setCoordinateReferenceSystem(this.crs);
        ReferencedEnvelope intersectionJTSEnvelope = new ReferencedEnvelope(intersectionEnvelope.getMinimum(0), intersectionEnvelope.getMaximum(0), intersectionEnvelope.getMinimum(1), intersectionEnvelope.getMaximum(1), this.crs);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("loading tile for envelope " + intersectionJTSEnvelope.toString());
        }
        if ((features = this.getFeaturesFromIndex(intersectionJTSEnvelope)) == null || features.size() == 0) {
            return this.background(requestedOriginalEnvelope, pixelDimension, outputTransparentColor);
        }
        Iterator<SimpleFeature> it = features.iterator();
        if (!it.hasNext()) {
            throw new DataSourceException("No data was found to match the actual request");
        }
        int size = features.size();
        if (size > maxNumTiles) {
            LOGGER.warning(new StringBuffer("We can load at most ").append(maxNumTiles).append(" tiles while there were requested ").append(size).append("\nI am going to print out a fake coverage, sorry about it!").toString());
            throw new DataSourceException("The maximum allowed number of tiles to be loaded was exceeded.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("We have " + size + " tiles to load");
        }
        try {
            return this.loadRequestedTiles(requestedOriginalEnvelope, intersectionEnvelope, transparentColor, outputTransparentColor, intersectionJTSEnvelope, features, it, inputImageThresholdValue, pixelDimension, size, fading, overviewPolicy);
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
    }

    private GridCoverage background(GeneralEnvelope requestedEnvelope, Rectangle dim, Color outputTransparentColor) {
        if (outputTransparentColor == null) {
            outputTransparentColor = Color.BLACK;
        }
        Number[] values = new Byte[]{new Byte((byte)outputTransparentColor.getRed()), new Byte((byte)outputTransparentColor.getGreen()), new Byte((byte)outputTransparentColor.getBlue()), (byte)0};
        RenderedOp constant = ConstantDescriptor.create((Float)new Float(dim.width), (Float)new Float(dim.height), (Number[])values, null);
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)constant, (org.opengis.geometry.Envelope)requestedEnvelope);
    }

    private GridCoverage loadRequestedTiles(GeneralEnvelope requestedOriginalEnvelope, GeneralEnvelope intersectionEnvelope, Color transparentColor, Color outputTransparentColor, Envelope requestedJTSEnvelope, List<SimpleFeature> features, Iterator<SimpleFeature> it, double inputImageThresholdValue, Rectangle dim, int numImages, boolean blend, OverviewPolicy overviewPolicy) throws DataSourceException, TransformException {
        try {
            double[] res;
            ParameterBlockJAI pbjMosaic = new ParameterBlockJAI("Mosaic");
            pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            ImageReadParam readP = new ImageReadParam();
            Integer imageChoice = dim != null ? this.setReadParams(overviewPolicy, readP, requestedOriginalEnvelope, dim) : new Integer(0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(imageChoice.toString()).append(" with subsampling factors ").append(readP.getSourceXSubsampling()).append(" ").append(readP.getSourceYSubsampling()).toString());
            }
            if (imageChoice == 0) {
                res = new double[this.highestRes.length];
                res[0] = this.highestRes[0];
                res[1] = this.highestRes[1];
            } else {
                double[] temp = this.overViewResolutions[imageChoice - 1];
                res = new double[temp.length];
                res[0] = temp[0];
                res[1] = temp[1];
            }
            res[0] = res[0] * (double)readP.getSourceXSubsampling();
            res[1] = res[1] * (double)readP.getSourceYSubsampling();
            Envelope loadedDataSetBound = this.getLoadedDataSetBoud(features);
            Point2D.Double ULC = new Point2D.Double(loadedDataSetBound.getMinX(), loadedDataSetBound.getMaxY());
            File tempFile = new File(this.sourceURL.getFile());
            String parentLocation = tempFile.getParent();
            ROI[] rois = new ROI[numImages];
            PlanarImage[] alphaChannels = new PlanarImage[numImages];
            Area finalLayout = new Area();
            boolean alphaIn = false;
            boolean doTransparentColor = false;
            boolean doInputImageThreshold = false;
            int[] alphaIndex = null;
            int i = 0;
            Boolean readMetadata = Boolean.FALSE;
            Boolean readThumbnails = Boolean.FALSE;
            Boolean verifyInput = Boolean.FALSE;
            ColorModel model = null;
            RenderedImage loadedImage = null;
            String location = null;
            int relativePath = -1;
            if (this.absolutePath) {
                relativePath = 1;
            }
            do {
                File imageFile;
                SimpleFeature feature = it.next();
                location = (String)feature.getAttribute(this.locationAttributeName);
                ReferencedEnvelope bound = ReferencedEnvelope.reference(feature.getBounds());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("About to read image number " + i);
                }
                if (!((imageFile = new File(relativePath == 1 ? location : new StringBuffer(parentLocation).append(File.separatorChar).append(location).toString())).exists() && imageFile.canRead() && imageFile.isFile())) {
                    if (relativePath == -1) {
                        imageFile = new File(location);
                        if (!(imageFile.exists() && imageFile.canRead() && imageFile.isFile())) {
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.info("Unable to read image for file " + imageFile.getAbsolutePath());
                            }
                            ++i;
                            continue;
                        }
                        relativePath = 1;
                    } else {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Unable to read image for file " + imageFile.getAbsolutePath());
                        }
                        ++i;
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("File found");
                }
                ParameterBlock pbjImageRead = new ParameterBlock();
                pbjImageRead.add(ImageIO.createImageInputStream(imageFile));
                pbjImageRead.add(imageChoice);
                pbjImageRead.add(readMetadata);
                pbjImageRead.add(readThumbnails);
                pbjImageRead.add(verifyInput);
                pbjImageRead.add(null);
                pbjImageRead.add(null);
                pbjImageRead.add(readP);
                pbjImageRead.add(null);
                loadedImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Just read image number " + i);
                }
                if (i == 0) {
                    model = loadedImage.getColorModel();
                    alphaIn = model.hasAlpha();
                    if (alphaIn) {
                        alphaIndex = new int[]{model.getNumComponents() - 1};
                    }
                    doInputImageThreshold = this.checkIfThresholdIsNeeded(loadedImage, inputImageThresholdValue);
                    if (transparentColor != null) {
                        int oldTransparentColor;
                        IndexColorModel icm;
                        int transparentPixel;
                        transparentColor = new Color(transparentColor.getRed(), transparentColor.getGreen(), transparentColor.getBlue());
                        doTransparentColor = true;
                        if (model instanceof IndexColorModel && alphaIn && model.getTransparency() == 2 && (transparentPixel = (icm = (IndexColorModel)model).getTransparentPixel()) != -1 && (oldTransparentColor = icm.getRGB(transparentPixel)) == transparentColor.getRGB()) {
                            doTransparentColor = false;
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding to mosaic image number " + i);
                }
                this.addToMosaic(pbjMosaic, bound, ULC, res, loadedImage, doInputImageThreshold, rois, i, inputImageThresholdValue, alphaIn, alphaIndex, alphaChannels, finalLayout, imageFile, doTransparentColor, transparentColor);
                ++i;
            } while (i < numImages);
            double th = ImageMosaicReader.getThreshold(loadedImage.getSampleModel().getDataType());
            pbjMosaic.setParameter("sourceThreshold", (Object)new double[][]{{th}});
            if (doInputImageThreshold) {
                pbjMosaic.setParameter("sourceROI", (Object)rois);
            } else if (alphaIn || doTransparentColor) {
                pbjMosaic.setParameter("sourceAlpha", (Object)alphaChannels);
            }
            if (blend) {
                pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_BLEND);
            }
            return this.prepareMosaic(location, requestedOriginalEnvelope, intersectionEnvelope, res, loadedDataSetBound, pbjMosaic, finalLayout, outputTransparentColor);
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this mosaic", e);
        }
    }

    private boolean checkIfThresholdIsNeeded(RenderedImage loadedImage, double thresholdValue) {
        if (Double.isNaN(thresholdValue) || Double.isInfinite(thresholdValue)) {
            return false;
        }
        switch (loadedImage.getSampleModel().getDataType()) {
            case 0: {
                int bTh = (int)thresholdValue;
                if (bTh <= 0 || bTh >= 255) {
                    return false;
                }
            }
            case 1: {
                int usTh = (int)thresholdValue;
                if (usTh <= 0 || usTh >= 65535) {
                    return false;
                }
            }
            case 2: {
                int sTh = (int)thresholdValue;
                if (sTh <= Short.MIN_VALUE || sTh >= Short.MAX_VALUE) {
                    return false;
                }
            }
            case 3: {
                int iTh = (int)thresholdValue;
                if (iTh <= Integer.MIN_VALUE || iTh >= Integer.MAX_VALUE) {
                    return false;
                }
            }
            case 4: {
                float fTh = (float)thresholdValue;
                if (fTh <= -3.4028235E38f || fTh >= Float.MAX_VALUE || Float.isInfinite(fTh) || Float.isNaN(fTh)) {
                    return false;
                }
            }
            case 5: {
                double dTh = thresholdValue;
                if (!(dTh <= -1.7976931348623157E308) && !(dTh >= Double.MAX_VALUE) && !Double.isInfinite(dTh) && !Double.isNaN(dTh)) break;
                return false;
            }
        }
        return true;
    }

    private static double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 1.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    private Envelope getLoadedDataSetBoud(List<SimpleFeature> features) throws IOException {
        Envelope loadedULC = new Envelope();
        for (SimpleFeature f : features) {
            loadedULC.expandToInclude(((Geometry)f.getDefaultGeometry()).getEnvelopeInternal());
        }
        return loadedULC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SimpleFeature> getFeaturesFromIndex(Envelope envelope) throws IOException {
        MemorySpatialIndex o;
        List<SimpleFeature> features = null;
        SoftReference<MemorySpatialIndex> softReference = this.index;
        synchronized (softReference) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Trying to  use the index...");
            }
            if ((o = this.index.get()) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index does not need to be created...");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index needa to be recreated...");
                }
                o = new MemorySpatialIndex(this.featureSource.getFeatures());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
        }
        features = o.findFeatures(envelope);
        if (features != null) {
            return features;
        }
        return Collections.emptyList();
    }

    private GridCoverage prepareMosaic(String location, GeneralEnvelope requestedOriginalEnvelope, GeneralEnvelope intersectionEnvelope, double[] res, Envelope loadedTilesEnvelope, ParameterBlockJAI pbjMosaic, Area finalLayout, Color outputTransparentColor) throws DataSourceException {
        RenderedOp preparationImage;
        GeneralEnvelope finalenvelope = null;
        Rectangle loadedTilePixelsBound = finalLayout.getBounds();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Loaded bbox ").append(loadedTilesEnvelope.toString()).append(" while requested bbox ").append(requestedOriginalEnvelope.toString()).toString());
        }
        GeneralEnvelope loadedTilesBoundEnv = new GeneralEnvelope(new double[]{loadedTilesEnvelope.getMinX(), loadedTilesEnvelope.getMinY()}, new double[]{loadedTilesEnvelope.getMaxX(), loadedTilesEnvelope.getMaxY()});
        loadedTilesBoundEnv.setCoordinateReferenceSystem(this.crs);
        double loadedTilesEnvelopeDim0 = loadedTilesBoundEnv.getLength(0);
        double loadedTilesEnvelopeDim1 = loadedTilesBoundEnv.getLength(1);
        if (!intersectionEnvelope.equals(loadedTilesBoundEnv, Math.min(loadedTilesEnvelopeDim0 / loadedTilePixelsBound.getWidth() / 2.0, loadedTilesEnvelopeDim1 / loadedTilePixelsBound.getHeight() / 2.0), false)) {
            GeneralEnvelope intersection = new GeneralEnvelope(intersectionEnvelope);
            intersection.intersect(loadedTilesBoundEnv);
            try {
                GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GeneralGridRange(loadedTilePixelsBound), loadedTilesBoundEnv);
                gridToEnvelopeMapper.setGridType(PixelInCell.CELL_CORNER);
                MathTransform transform = gridToEnvelopeMapper.createTransform().inverse();
                GeneralGridRange finalRange = new GeneralGridRange((org.opengis.geometry.Envelope)CRS.transform(transform, (org.opengis.geometry.Envelope)intersection));
                finalLayout.intersect(new Area(finalRange.toRectangle()));
                Rectangle tempRect = finalLayout.getBounds();
                preparationImage = JAI.create((String)"Mosaic", (ParameterBlock)pbjMosaic, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(tempRect.x, tempRect.y, tempRect.width, tempRect.height)));
                finalenvelope = intersection;
            }
            catch (MismatchedDimensionException e) {
                throw new DataSourceException("Problem when creating this mosaic.", e);
            }
            catch (NoninvertibleTransformException e) {
                throw new DataSourceException("Problem when creating this mosaic.", e);
            }
            catch (TransformException e) {
                throw new DataSourceException("Problem when creating this mosaic.", e);
            }
        } else {
            preparationImage = JAI.create((String)"Mosaic", (ParameterBlock)pbjMosaic);
            finalenvelope = new GeneralEnvelope(intersectionEnvelope);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Mosaic created ").toString());
        }
        if (outputTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Support for alpha").toString());
            }
            ImageWorker w = new ImageWorker((RenderedImage)preparationImage);
            preparationImage = preparationImage.getColorModel() instanceof IndexColorModel ? w.makeColorTransparent(outputTransparentColor).getPlanarImage() : w.makeColorTransparent(outputTransparentColor).getPlanarImage();
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)preparationImage, (org.opengis.geometry.Envelope)finalenvelope);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)preparationImage, (org.opengis.geometry.Envelope)finalenvelope);
    }

    private void addToMosaic(ParameterBlockJAI pbjMosaic, Envelope bound, Point2D ulc, double[] res, RenderedImage loadedImage, boolean doInputImageThreshold, ROI[] rois, int i, double inputImageThresholdValue, boolean alphaIn, int[] alphaIndex, PlanarImage[] alphaChannels, Area finalLayout, File imageFile, boolean doTransparentColor, Color transparentColor) {
        ImageWorker w;
        RenderedImage readyToMosaicImage = this.scaleAndTranslate(bound, ulc, res, loadedImage);
        if (this.expandMe && readyToMosaicImage.getColorModel() instanceof IndexColorModel) {
            readyToMosaicImage = new ImageWorker(readyToMosaicImage).forceComponentColorModel().getPlanarImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Support for alpha on input image number " + i).toString());
            }
            w = new ImageWorker(readyToMosaicImage);
            readyToMosaicImage = readyToMosaicImage.getColorModel() instanceof IndexColorModel ? w.makeColorTransparent(transparentColor).getPlanarImage() : w.makeColorTransparent(transparentColor).getPlanarImage();
            alphaIndex = new int[]{readyToMosaicImage.getColorModel().getNumComponents() - 1};
        }
        if (doInputImageThreshold) {
            w = new ImageWorker(readyToMosaicImage);
            w.tileCacheEnabled(false).intensity().binarize(inputImageThresholdValue);
            rois[i] = w.getImageAsROI();
        } else if (alphaIn || doTransparentColor) {
            w = new ImageWorker(readyToMosaicImage);
            alphaChannels[i] = readyToMosaicImage.getColorModel() instanceof IndexColorModel ? w.forceComponentColorModel().retainLastBand().getPlanarImage() : w.retainBands(alphaIndex).getPlanarImage();
        }
        pbjMosaic.addSource((Object)readyToMosaicImage);
        finalLayout.add(new Area(PlanarImage.wrapRenderedImage((RenderedImage)readyToMosaicImage).getBounds()));
    }

    private RenderedImage scaleAndTranslate(Envelope bound, Point2D ulc, double[] res, RenderedImage image) {
        double resX = (bound.getMaxX() - bound.getMinX()) / (double)image.getWidth();
        double resY = (bound.getMaxY() - bound.getMinY()) / (double)image.getHeight();
        double scaleX = 1.0;
        double scaleY = 1.0;
        double xTrans = 0.0;
        double yTrans = 0.0;
        if (Math.abs((resX - res[0]) / resX) > 1.0E-6 || Math.abs(resY - res[1]) > 1.0E-6) {
            scaleX = res[0] / resX;
            scaleY = res[1] / resY;
        }
        xTrans = (bound.getMinX() - ulc.getX()) / res[0];
        yTrans = (ulc.getY() - bound.getMaxY()) / res[1];
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset((int)Math.round(xTrans));
        layout.setTileGridYOffset((int)Math.round(yTrans));
        ParameterBlock pbjAffine = new ParameterBlock();
        if (Math.abs(xTrans - (double)((int)xTrans)) < Math.pow(10.0, -3.0) && Math.abs(yTrans - (double)((int)yTrans)) < Math.pow(10.0, -3.0) && Math.abs(scaleX - 1.0) < Math.pow(10.0, -6.0) && Math.abs(scaleY - 1.0) < Math.pow(10.0, -6.0)) {
            if (Math.abs(xTrans) < Math.pow(10.0, -3.0) && Math.abs(yTrans) < Math.pow(10.0, -3.0)) {
                return image;
            }
            pbjAffine.addSource(image).add(new Float(xTrans)).add(new Float(yTrans)).add(ImageUtilities.NN_INTERPOLATION_HINT.get(JAI.KEY_INTERPOLATION));
            RenderingHints hints = (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL.clone();
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            return JAI.create((String)"Translate", (ParameterBlock)pbjAffine, (RenderingHints)hints);
        }
        AffineTransform tx = new AffineTransform(scaleX, 0.0, 0.0, scaleY, xTrans, yTrans);
        pbjAffine.addSource(image).add(tx).add(ImageUtilities.NN_INTERPOLATION_HINT.get(JAI.KEY_INTERPOLATION));
        RenderingHints hints = (RenderingHints)ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL.clone();
        hints.add(ImageUtilities.EXTEND_BORDER_BY_COPYING);
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"Affine", (ParameterBlock)pbjAffine, (RenderingHints)hints);
    }
}

