/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import java.util.Locale;
import simple.util.PriorityQueue;
import simple.util.parse.ParseBuffer;
import simple.util.parse.Parser;

public class LanguageParser
extends Parser {
    private PriorityQueue queue;
    private Locale[] list;
    private ParseBuffer primary = new ParseBuffer();
    private ParseBuffer subtag = new ParseBuffer();
    private int qvalue;
    private boolean finished;
    private boolean parsed;

    public LanguageParser() {
        this.queue = new PriorityQueue();
    }

    public LanguageParser(String value) {
        this();
        this.parse(value);
    }

    private void pack() {
        int len = this.count;
        int seek = 0;
        int pos = 0;
        char old = this.buf[0];
        block0: while (seek < len) {
            char ch;
            if ((ch = this.buf[seek++]) == '\"' && old != '\\') {
                this.buf[pos++] = ch;
                while (seek < len) {
                    old = this.buf[seek - 1];
                    ch = this.buf[seek++];
                    this.buf[pos++] = ch;
                    if (ch == '\"' && old != '\\') continue block0;
                }
                continue;
            }
            if (this.space(ch)) continue;
            old = this.buf[seek - 1];
            this.buf[pos++] = old;
        }
        this.count = pos;
    }

    public Locale getLocale() {
        if (this.list == null) {
            this.build();
        }
        if (this.list.length > 0) {
            return this.list[0];
        }
        return null;
    }

    public Locale[] getLocales() {
        if (this.list == null) {
            this.build();
        }
        return this.list;
    }

    private void build() {
        this.list = new Locale[this.queue.length()];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = (Locale)this.queue.remove();
            ++i;
        }
    }

    protected void parse() {
        while (this.hasMore()) {
            Locale lang = this.next();
            this.queue.add(lang, this.qvalue);
        }
    }

    protected void init() {
        this.finished = false;
        this.parsed = false;
        this.list = null;
        this.pack();
        this.clear();
        this.off = 0;
    }

    private Locale next() {
        if (!this.hasMore()) {
            return null;
        }
        this.parsed = false;
        String prime = this.primary.toString();
        String sub = null;
        if (this.subtag.length() > 0) {
            sub = this.subtag.toString();
            return new Locale(prime, sub);
        }
        return new Locale(prime, "");
    }

    private boolean hasMore() {
        if (this.finished) {
            return false;
        }
        if (this.parsed) {
            return true;
        }
        this.clear();
        this.language();
        this.parsed = true;
        if (this.primary.length() <= 0) {
            this.finished = true;
            return false;
        }
        return true;
    }

    private void clear() {
        this.primary.clear();
        this.subtag.clear();
    }

    private void language() {
        if (this.skip("*")) {
            this.primary.append('*');
        } else {
            this.primarytag();
            while (this.skip("-")) {
                this.subtag();
            }
        }
        this.qvalue();
        ++this.off;
    }

    private void primarytag() {
        int end = this.off + 8;
        while (this.off < end && this.off < this.count) {
            if (!this.alpha(this.buf[this.off])) break;
            this.primary.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private boolean alpha(char c) {
        return c <= 'z' && 'a' <= c || c <= 'Z' && 'A' <= c;
    }

    private void subtag() {
        int end = this.off + 8;
        while (this.off < end && this.off < this.count) {
            if (!this.alpha(this.buf[this.off])) break;
            this.subtag.append(this.buf[this.off]);
            ++this.off;
        }
    }

    private void qvalue() {
        this.qvalue = 0;
        if (this.skip(";q=")) {
            while (this.off < this.count) {
                if (this.buf[this.off] == '.') {
                    ++this.off;
                    continue;
                }
                if (this.digit(this.buf[this.off])) {
                    this.qvalue *= 10;
                    this.qvalue += this.buf[this.off];
                    this.qvalue -= 48;
                    ++this.off;
                    continue;
                }
                break;
            }
        } else {
            this.qvalue = 10;
        }
    }
}

