/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.FileNotFoundException;
import java.io.IOException;
import simple.http.Request;
import simple.http.Response;
import simple.http.serve.Context;
import simple.http.serve.ErrorReport;
import simple.http.serve.Format;
import simple.http.serve.Report;
import simple.http.serve.Resource;
import simple.http.serve.StatusReport;

public abstract class Component
implements Resource {
    protected Context context;

    protected Component() {
    }

    protected Component(Context context) {
        this.context = context;
    }

    public void handle(Request req, Response resp) {
        try {
            this.process(req, resp);
        }
        catch (SecurityException cause) {
            this.handle(req, resp, new ErrorReport(cause, 403));
        }
        catch (FileNotFoundException cause) {
            this.handle(req, resp, new ErrorReport(cause, 404));
        }
        catch (Throwable cause) {
            this.handle(req, resp, new ErrorReport(cause, 500));
        }
    }

    public void handle(Request req, Response resp, int code) {
        this.handle(req, resp, new StatusReport(code));
    }

    public void handle(Request req, Response resp, Report report) {
        try {
            if (!resp.isCommitted()) {
                resp.reset();
                this.process(req, resp, report);
            }
            resp.getOutputStream().close();
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void process(Request req, Response resp, int code) throws Exception {
        this.process(req, resp, new StatusReport(code));
    }

    protected void process(Request req, Response resp, Report report) throws Exception {
        Format format = this.context.getFormat();
        byte[] page = format.getMessage(this.context, req.getURI(), report);
        resp.setCode(report.getCode());
        resp.setText(report.getText());
        resp.setDate("Date", System.currentTimeMillis());
        resp.setContentLength(page.length);
        resp.set("Content-Type", format.getContentType());
        resp.getOutputStream().write(page);
        resp.getOutputStream().close();
    }

    protected abstract void process(Request var1, Response var2) throws Exception;
}

