/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSourceUtils {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.feature");

    public static Envelope getBoundingBoxEnvelope(FeatureSource<SimpleFeatureType, SimpleFeature> fs) throws IOException {
        ReferencedEnvelope ev = fs.getBounds();
        if (ev == null || ev.isNull()) {
            try {
                ev = fs.getFeatures().getBounds();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "Could not compute the data bounding box. Returning an empty envelope", t);
                ev = new Envelope();
            }
        }
        return ev;
    }
}

