/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.geotiff.adapters.GeoTiffIIOMetadataDecoder;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;

public final class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.geotiff");

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org:16080/websites/geotiff/geotiff.html");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{AbstractGridFormat.GEOTOOLS_WRITE_PARAMS}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean accepts(Object o) {
        block81: {
            ImageInputStream inputStream;
            ImageReader reader;
            block79: {
                boolean e22222222222222222222;
                block80: {
                    GeoTiffIIOMetadataDecoder metadataAdapter;
                    block77: {
                        boolean e22222222222222222222;
                        block78: {
                            IIOMetadata metadata;
                            block75: {
                                boolean e32222222222;
                                block76: {
                                    block73: {
                                        boolean url22222222222222222222;
                                        block74: {
                                            block71: {
                                                boolean url22222222222222222222;
                                                block72: {
                                                    block69: {
                                                        boolean bl;
                                                        block70: {
                                                            if (o == null) {
                                                                return false;
                                                            }
                                                            reader = null;
                                                            inputStream = null;
                                                            if (!(o instanceof URL)) break block69;
                                                            URL url22222222222222222222 = (URL)o;
                                                            if (url22222222222222222222.getProtocol().equalsIgnoreCase("file")) {
                                                                o = new File(URLDecoder.decode(url22222222222222222222.getFile(), "UTF-8"));
                                                                break block69;
                                                            }
                                                            if (url22222222222222222222.getProtocol().equalsIgnoreCase("http") || url22222222222222222222.getProtocol().equalsIgnoreCase("ftp")) {
                                                                o = ((URL)o).openStream();
                                                                break block69;
                                                            }
                                                            bl = false;
                                                            if (reader == null) break block70;
                                                            try {
                                                                reader.dispose();
                                                            }
                                                            catch (Exception e4) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (inputStream != null) {
                                                            try {
                                                                inputStream.close();
                                                            }
                                                            catch (Exception e5) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return bl;
                                                    }
                                                    inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o));
                                                    if (inputStream != null) break block71;
                                                    if (LOGGER.isLoggable(Level.FINE)) {
                                                        LOGGER.fine("Unable to get an ImageInputStream");
                                                    }
                                                    url22222222222222222222 = false;
                                                    if (reader == null) break block72;
                                                    try {
                                                        reader.dispose();
                                                    }
                                                    catch (Exception e6) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Exception e7) {
                                                        // empty catch block
                                                    }
                                                }
                                                return url22222222222222222222;
                                            }
                                            inputStream.mark();
                                            if (spi.canDecodeInput((Object)inputStream)) break block73;
                                            url22222222222222222222 = false;
                                            if (reader == null) break block74;
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception e8) {
                                                // empty catch block
                                            }
                                        }
                                        if (inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Exception e32222222222) {
                                                // empty catch block
                                            }
                                        }
                                        return url22222222222222222222;
                                    }
                                    reader = spi.createReaderInstance();
                                    reader.setInput(inputStream);
                                    metadata = reader.getImageMetadata(0);
                                    if (metadata != null) break block75;
                                    e32222222222 = false;
                                    if (reader == null) break block76;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception e9) {
                                        // empty catch block
                                    }
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Exception e22222222222222222222) {
                                        // empty catch block
                                    }
                                }
                                return e32222222222;
                            }
                            metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                            if (metadataAdapter != null) break block77;
                            e22222222222222222222 = false;
                            if (reader == null) break block78;
                            try {
                                reader.dispose();
                            }
                            catch (Exception e10) {
                                // empty catch block
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception e11) {
                                // empty catch block
                            }
                        }
                        return e22222222222222222222;
                    }
                    if (metadataAdapter.getGeoKeyRevision() == 1) break block79;
                    e22222222222222222222 = false;
                    if (reader == null) break block80;
                    try {
                        reader.dispose();
                    }
                    catch (Exception e12) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e13) {
                        // empty catch block
                    }
                }
                return e22222222222222222222;
            }
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
            break block81;
            catch (Throwable e) {
                try {
                    MathTransform raster2Model;
                    if (e instanceof IllegalArgumentException && (raster2Model = GeoTiffReader.parseWorldFile(o)) != null) {
                        boolean e22222222222222222222 = true;
                        return e22222222222222222222;
                    }
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            {
                finally {
                    if (reader != null) {
                        try {
                            reader.dispose();
                        }
                        catch (Exception e2) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e3) {}
                    }
                }
            }
        }
        return true;
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                String pathname = URLDecoder.decode(url.getFile(), "UTF-8");
                return new GeoTiffReader(new File(pathname), hints);
            }
            catch (UnsupportedEncodingException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

