/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.Point;
import org.postgresql.util.PGtokenizer;

public class MultiPoint
extends Geometry {
    Point[] points;

    public MultiPoint() {
        this.type = Geometry.MULTIPOINT;
    }

    public MultiPoint(Point[] points) {
        this();
        this.points = points;
        this.dimension = points[0].dimension;
    }

    public MultiPoint(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("MULTIPOINT") == 0) {
            PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value.substring(10).trim()), ',');
            int npoints = t.getSize();
            this.points = new Point[npoints];
            int p = 0;
            while (p < npoints) {
                this.points[p] = new Point(t.getToken(p));
                ++p;
            }
        } else {
            throw new SQLException("postgis.multipointgeometry");
        }
        this.dimension = this.points[0].dimension;
    }

    public String toString() {
        return "MULTIPOINT " + this.getValue();
    }

    public String getValue() {
        StringBuffer b = new StringBuffer("(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].getValue());
            ++p;
        }
        b.append(")");
        return b.toString();
    }

    public int numPoints() {
        return this.points.length;
    }

    public Point getPoint(int idx) {
        if (idx >= 0 & idx < this.points.length) {
            return this.points[idx];
        }
        return null;
    }
}

