/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.wms.BBOX;

public class SeedTask
extends GWCTask {
    private static Log log = LogFactory.getLog(SeedTask.class);
    private final SeedRequest req;
    private final TileLayer tl;
    private boolean reseed = false;
    private StorageBroker storageBroker;

    public SeedTask(StorageBroker sb, SeedRequest req, TileLayer tl, boolean reseed) {
        this.storageBroker = sb;
        this.req = req;
        this.tl = tl;
        this.reseed = reseed;
        this.type = reseed ? 1 : 0;
        this.layerName = tl.getName();
    }

    public void doAction() throws GeoWebCacheException {
        BBOX bounds;
        Thread.currentThread().setPriority(3);
        long START_TIME = System.currentTimeMillis();
        this.tl.isInitialized();
        log.info((Object)("Thread " + this.threadOffset + " begins seeding layer : " + this.tl.getName()));
        int zoomStart = this.req.getZoomStart();
        int zoomStop = this.req.getZoomStop();
        MimeType mimeType = null;
        String format = this.req.getMimeFormat();
        if (format == null) {
            mimeType = this.tl.getMimeTypes().get(0);
        } else {
            try {
                mimeType = MimeType.createFromFormat(format);
            }
            catch (MimeException e4) {
                e4.printStackTrace();
            }
        }
        SRS srs = this.req.getSRS();
        if (srs == null) {
            srs = this.tl.getGrids().entrySet().iterator().next().getKey();
        }
        if ((bounds = this.req.getBounds()) == null) {
            bounds = this.tl.getGrid(srs).getBounds();
        }
        int[][] coveredGridLevels = this.tl.getCoveredGridLevels(srs, bounds);
        int[] metaTilingFactors = this.tl.getMetaTilingFactors();
        int tilesPerMetaTile = metaTilingFactors[0] * metaTilingFactors[1];
        int arrayIndex = this.getCurrentThreadArrayIndex();
        long TOTAL_TILES = this.tileCount(coveredGridLevels, zoomStart, zoomStop);
        this.tilesTotal = TOTAL_TILES / (long)this.threadCount;
        int count = 0;
        boolean tryCache = !this.reseed;
        for (int level = zoomStart; level <= zoomStop && !this.terminate; ++level) {
            int[] gridBounds = coveredGridLevels[level];
            for (int gridy = gridBounds[1]; gridy <= gridBounds[3]; gridy += metaTilingFactors[1]) {
                for (int gridx = gridBounds[0] + this.threadOffset; gridx <= gridBounds[2] && !this.terminate; gridx += metaTilingFactors[0]) {
                    int[] gridLoc = new int[]{gridx, gridy, level};
                    ConveyorTile tile = new ConveyorTile(this.storageBroker, this.tl.getName(), srs, gridLoc, mimeType, null, null, null, null);
                    try {
                        this.tl.seedTile(tile, tryCache);
                    }
                    catch (IOException ioe) {
                        throw new GeoWebCacheException(ioe.getMessage());
                    }
                    int countX = gridx + metaTilingFactors[0] - 1 > gridBounds[2] ? gridx + metaTilingFactors[0] - 1 - gridBounds[2] : metaTilingFactors[0];
                    int countY = gridy + metaTilingFactors[1] - 1 > gridBounds[3] ? gridy + metaTilingFactors[1] - 1 - gridBounds[3] : metaTilingFactors[1];
                    this.updateStatusInfo(arrayIndex, this.tl, count += countX * countY, START_TIME);
                }
            }
            double percCompl = 100.0 * (double)count / (double)(this.tilesTotal * (long)tilesPerMetaTile);
            int intPercCompl = (int)Math.floor(percCompl);
            int decPercCompl = (int)Math.round((percCompl - (double)intPercCompl) * 100.0);
            if (intPercCompl < 0) {
                intPercCompl = 0;
                decPercCompl = 0;
            }
            log.info((Object)("Thread " + this.threadOffset + " completed (re)seeding level " + level + " for layer " + this.tl.getName() + " (ca. " + intPercCompl + "." + decPercCompl + "%)"));
        }
        if (this.terminate) {
            log.info((Object)("Thread " + this.threadOffset + " was terminated after " + this.tilesDone + " tiles"));
        } else {
            log.info((Object)("Thread " + this.threadOffset + " completed (re)seeding layer " + this.tl.getName() + " after " + this.tilesDone + " tiles, of an estimated " + this.tilesTotal));
        }
    }

    private long tileCount(int[][] coveredGridLevels, int startZoom, int stopZoom) {
        long count = 0L;
        for (int i = startZoom; i <= stopZoom; ++i) {
            int[] gridBounds = coveredGridLevels[i];
            count += (long)((1 + gridBounds[2] - gridBounds[0]) * (1 + gridBounds[3] - gridBounds[1]));
        }
        return count;
    }

    private int getCurrentThreadArrayIndex() {
        String tn = Thread.currentThread().getName();
        int indexOfnumber = tn.indexOf(100) + 2;
        String tmp = tn.substring(indexOfnumber);
        return Integer.parseInt(tmp) - 1;
    }

    private void updateStatusInfo(int arrayIndex, TileLayer layer, int tilesCount, long start_time) {
        this.tilesDone = tilesCount;
        this.timeSpent = (int)(System.currentTimeMillis() - start_time) / 1000;
        long timeTotal = Math.round((double)this.timeSpent * ((double)this.tilesTotal / (double)tilesCount));
        this.timeRemaining = (int)(timeTotal - (long)this.timeSpent);
    }
}

