/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.operator.CropDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.wms.BBOX;

public class WMSMetaTile
extends MetaTile {
    private static Log log = LogFactory.getLog(WMSMetaTile.class);
    private BufferedImage img = null;
    private RenderedImage[] tiles = null;
    private final RenderingHints no_cache = new RenderingHints(JAI.KEY_TILE_CACHE, null);
    protected WMSLayer wmsLayer = null;
    protected boolean requestTiled = false;
    protected String fullParameters;

    protected WMSMetaTile(WMSLayer layer, SRS srs, MimeType mimeType, int[] gridBounds, int[] tileGridPosition, int metaX, int metaY, String fullParameters) {
        super(srs, mimeType, gridBounds, tileGridPosition, metaX, metaY);
        this.wmsLayer = layer;
        this.fullParameters = fullParameters;
    }

    protected String getWMSParams() throws GeoWebCacheException {
        String baseParameters = this.wmsLayer.getWMSRequestTemplate();
        StringBuilder strBuilder = new StringBuilder(baseParameters);
        strBuilder.append("&FORMAT=").append(this.mimeType.getFormat());
        strBuilder.append("&SRS=").append(this.srs.toString());
        strBuilder.append("&WIDTH=").append(this.metaX * 256);
        strBuilder.append("&HEIGHT=").append(this.metaY * 256);
        GridCalculator gridCalc = this.wmsLayer.getGrid(this.srs).getGridCalculator();
        BBOX metaBbox = gridCalc.bboxFromGridBounds(this.metaTileGridBounds);
        strBuilder.append("&BBOX=").append(metaBbox);
        strBuilder.append(this.fullParameters);
        return strBuilder.toString();
    }

    protected WMSLayer getLayer() {
        return this.wmsLayer;
    }

    protected void setImageBytes(byte[] image) throws GeoWebCacheException {
        if (image == null) {
            throw new GeoWebCacheException("WMSMetaTile.setImageBytes()  received null instead of byte[]");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(image);
        try {
            this.img = ImageIO.read(is);
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("WMSMetaTile.setImageBytes() failed on ImageIO.read(byte[" + image.length + "])");
        }
    }

    protected void createTiles(int tileWidth, int tileHeight, boolean useJAI) {
        int tileCount = this.metaX * this.metaY;
        this.tiles = new RenderedImage[tileCount];
        if (tileCount > 1) {
            for (int y = 0; y < this.metaY; ++y) {
                for (int x = 0; x < this.metaX; ++x) {
                    int i = x * tileWidth;
                    int j = (this.metaY - 1 - y) * tileHeight;
                    this.tiles[y * this.metaX + x] = this.createTile(i, j, tileWidth, tileHeight, useJAI);
                }
            }
        } else {
            this.tiles[0] = this.img;
        }
    }

    private RenderedImage createTile(int minX, int minY, int tileWidth, int tileHeight, boolean useJAI) {
        BufferedImage tile = null;
        if (useJAI) {
            try {
                tile = CropDescriptor.create((RenderedImage)this.img, (Float)new Float(minX), (Float)new Float(minY), (Float)new Float(tileWidth), (Float)new Float(tileHeight), (RenderingHints)this.no_cache);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Error cropping, image is " + this.img.getWidth() + "x" + this.img.getHeight() + ", requesting a " + tileWidth + "x" + tileHeight + " tile starting at " + minX + "," + minY + "."));
                log.error((Object)("Message from JAI: " + iae.getMessage()));
                iae.printStackTrace();
            }
        } else {
            try {
                tile = this.img.getSubimage(minX, minY, tileWidth, tileHeight);
            }
            catch (RasterFormatException rfe) {
                log.error((Object)("RendereedImage.getSubimage(" + minX + "," + minY + "," + tileWidth + "," + tileHeight + ") threw exception:"));
                rfe.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thread: " + Thread.currentThread().getName() + "\n" + ((Object)tile).toString() + ", " + "Information from tile (width, height, minx, miny): " + tile.getWidth() + ", " + tile.getHeight() + ", " + tile.getMinX() + ", " + tile.getMinY() + "\n" + "Information set (width, height, minx, miny): " + new Float(tileWidth) + ", " + new Float(tileHeight) + ", " + new Float(minX) + ", " + new Float(minY)));
        }
        return tile;
    }

    protected boolean writeTileToStream(int tileIdx, OutputStream os) throws IOException {
        if (this.tiles != null) {
            String format = this.mimeType.getInternalName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread: " + Thread.currentThread().getName() + " writing: " + tileIdx));
            }
            if (!ImageIO.write(this.tiles[tileIdx], format, os)) {
                log.error((Object)("javax.imageio.ImageIO.write(" + this.tiles[tileIdx].toString() + "," + format + "," + os.toString() + ")"));
            }
            return true;
        }
        return false;
    }

    public String debugString() {
        return " metaX: " + this.metaX + " metaY: " + this.metaY + " metaGrid: " + Arrays.toString(this.metaTileGridBounds);
    }
}

