/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.Hashtable;
import org.geowebcache.GeoWebCacheException;

public class SRS {
    private final int number;
    private static final transient SRS epsg4326 = new SRS(4326);
    private static final transient SRS epsg900913 = new SRS(900913);
    private static Hashtable<Integer, SRS> list = new Hashtable();

    private SRS(int epsgNumber) {
        this.number = epsgNumber;
    }

    public static SRS getSRS(int epsgNumber) {
        SRS ret = list.get(epsgNumber);
        if (ret == null) {
            if (epsgNumber == 4326) {
                list.put(4326, SRS.getEPSG4326());
            } else if (epsgNumber == 900913) {
                list.put(900913, SRS.getEPSG900913());
            }
            ret = new SRS(epsgNumber);
            list.put(epsgNumber, ret);
        }
        return ret;
    }

    public static SRS getSRS(String epsgStr) throws GeoWebCacheException {
        if (epsgStr.substring(0, 5).equalsIgnoreCase("EPSG:")) {
            int epsgNumber = Integer.parseInt(epsgStr.substring(5, epsgStr.length()));
            return SRS.getSRS(epsgNumber);
        }
        throw new GeoWebCacheException("Can't parse " + epsgStr + " as SRS string.");
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SRS otherSRS = (SRS)other;
        return otherSRS.number == this.number;
    }

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "EPSG:" + Integer.toString(this.number);
    }

    public String filePath() {
        return "EPSG_" + Integer.toString(this.number);
    }

    public static SRS getEPSG4326() {
        return epsg4326;
    }

    public static SRS getEPSG900913() {
        return epsg900913;
    }
}

