/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.demo.Demo;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.OutOfBoundsException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.service.Service;
import org.geowebcache.storage.StorageBroker;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GeoWebCacheDispatcher
extends AbstractController {
    private static Log log = LogFactory.getLog(GeoWebCacheDispatcher.class);
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_DEMO = "demo";
    private TileLayerDispatcher tileLayerDispatcher = null;
    private StorageBroker storageBroker = null;
    private HashMap<String, Service> services = null;
    private byte[] blankPNG8 = null;
    private String servletPrefix = null;

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.tileLayerDispatcher = tileLayerDispatcher;
        log.info((Object)"set TileLayerDispatcher");
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = !servletPrefix.startsWith("/") ? "/" + servletPrefix : servletPrefix;
        log.info((Object)("Invoked setServletPrefix(" + servletPrefix + ")"));
    }

    private void loadServices() {
        WebApplicationContext context = (WebApplicationContext)this.getApplicationContext();
        Map serviceBeans = context.getBeansOfType(Service.class);
        Iterator beanIter = serviceBeans.keySet().iterator();
        this.services = new HashMap();
        while (beanIter.hasNext()) {
            Service aService = (Service)serviceBeans.get(beanIter.next());
            this.services.put(aService.getPathName(), aService);
        }
    }

    private void loadBlankPNG8() {
        InputStream is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");
        this.blankPNG8 = new byte[129];
        try {
            int ret = is.read(this.blankPNG8);
            log.info((Object)("Read " + ret + " from blank PNG8 file (expected 129)."));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block12: {
            String[] requestComps = null;
            try {
                String normalizedURI = request.getRequestURI().replaceFirst(request.getContextPath(), "");
                if (this.servletPrefix != null) {
                    normalizedURI = normalizedURI.replaceFirst(this.servletPrefix, "");
                }
                requestComps = this.parseRequest(normalizedURI);
            }
            catch (GeoWebCacheException gwce) {
                GeoWebCacheDispatcher.writeError(response, 400, gwce.getMessage());
                return null;
            }
            try {
                if (requestComps == null) {
                    GeoWebCacheDispatcher.handleFrontPage(request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_SERVICE)) {
                    this.handleServiceRequest(requestComps[1], request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_DEMO)) {
                    this.handleDemoRequest(requestComps[1], request, response);
                } else {
                    GeoWebCacheDispatcher.writeError(response, 404, "Unknown path: " + requestComps[0]);
                }
            }
            catch (Exception e) {
                if (!(e instanceof BadTileException) || log.isDebugEnabled()) {
                    log.error((Object)(e.getMessage() + " " + request.getRequestURL().toString()));
                }
                GeoWebCacheDispatcher.writeError(response, 400, e.getMessage());
                if (e instanceof GeoWebCacheException && !log.isDebugEnabled()) break block12;
                e.printStackTrace();
            }
        }
        return null;
    }

    public void destroy() {
        log.info((Object)"GeoWebCacheDispatcher.destroy() was invoked, shutting down.");
    }

    private String[] parseRequest(String servletPath) throws GeoWebCacheException {
        String[] retStrs = new String[2];
        String[] splitStr = servletPath.split("/");
        if (splitStr == null || splitStr.length < 2) {
            return null;
        }
        retStrs[0] = splitStr[1];
        if (splitStr.length > 2) {
            retStrs[1] = splitStr[2];
        }
        return retStrs;
    }

    private void handleServiceRequest(String serviceStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Conveyor conv = null;
        Service service = this.findService(serviceStr);
        conv = service.getConveyor(request, response);
        if (conv.reqHandler == Conveyor.RequestHandler.SERVICE) {
            service.handleRequest(conv);
        } else {
            ConveyorTile convTile = (ConveyorTile)conv;
            TileLayer layer = this.tileLayerDispatcher.getTileLayer(convTile.getLayerId());
            convTile.setTileLayer(layer);
            try {
                layer.getTile(convTile);
                this.writeData(convTile);
            }
            catch (OutOfBoundsException e) {
                this.writeEmpty(convTile, e.getMessage());
            }
        }
    }

    private void handleDemoRequest(String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        Demo.makeMap(this.tileLayerDispatcher, action, request, response);
    }

    private Service findService(String serviceStr) throws GeoWebCacheException {
        Service service;
        if (this.services == null) {
            this.loadServices();
            this.loadBlankPNG8();
        }
        if ((service = this.services.get(serviceStr)) == null) {
            serviceStr = serviceStr == null || serviceStr.length() == 0 ? ", try service/&lt;name of service&gt;" : " \"" + serviceStr + "\"";
            throw new GeoWebCacheException("Unable to find handler for service" + serviceStr);
        }
        return service;
    }

    private static void handleFrontPage(HttpServletRequest request, HttpServletResponse response) {
        String url;
        if (request.getRequestURL().toString().endsWith("/")) {
            url = "./demo";
        } else {
            String[] strs = request.getRequestURL().toString().split("/");
            url = strs[strs.length - 1] + "/demo";
        }
        String message = "<html><body>\n<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"http://geowebcache.org/trac/chrome/site/geowebcache_logo.png\"height=\"100\" width=\"353\" border=\"0\"/></a>\n<h4>Welcome to GeoWebCache</h4><a href=\"" + url + "\">Dynamic list of layers</a>" + "</body></html>\n";
        GeoWebCacheDispatcher.writePage(response, 200, message);
    }

    private static void writeError(HttpServletResponse response, int httpCode, String errorMsg) {
        log.debug((Object)errorMsg);
        errorMsg = "<html><body>\n<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"http://geowebcache.org/trac/chrome/site/geowebcache_logo.png\"height=\"100\" width=\"353\" border=\"0\"/></a>\n<h4>" + httpCode + ": " + errorMsg + "</h4>" + "</body></html>\n";
        GeoWebCacheDispatcher.writePage(response, httpCode, errorMsg);
    }

    private static void writePage(HttpServletResponse response, int httpCode, String message) {
        response.setContentType("text/html");
        response.setStatus(httpCode);
        if (message == null) {
            return;
        }
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(message.getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void writeData(ConveyorTile tile) throws IOException {
        byte[] data = tile.getContent();
        HttpServletResponse response = tile.servletResp;
        if (tile.getError() && data != null) {
            log.error((Object)"writeData() oops.. no data or tile was null");
        } else {
            response.setStatus(tile.getStatus());
            response.setContentType(tile.getMimeType().getMimeType());
            if (data != null) {
                response.setContentLength(data.length);
                try {
                    ServletOutputStream os = response.getOutputStream();
                    os.write(data);
                }
                catch (IOException ioe) {
                    log.debug((Object)("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString()));
                }
            }
        }
    }

    private void writeEmpty(ConveyorTile tile, String message) {
        tile.servletResp.setHeader("geowebcache-message", message);
        tile.servletResp.setStatus(200);
        tile.servletResp.setContentType(ImageMime.png.getMimeType());
        TileLayer layer = tile.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(tile.servletResp);
        }
        try {
            tile.servletResp.getOutputStream().write(this.blankPNG8);
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString()));
        }
    }
}

