/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsLike;

public class LikeFilterImpl
extends AbstractFilterImpl
implements LikeFilter {
    private Expression attribute = null;
    private String pattern = null;
    private String wildcardSingle = ".?";
    private String wildcardMulti = ".*";
    private String escape = "\\";
    private Pattern compPattern = null;
    private Matcher match = null;

    public static String convertToSQL92(char escape, char multi, char single, String pattern) throws IllegalArgumentException {
        if (escape == '\'' || multi == '\'' || single == '\'') {
            throw new IllegalArgumentException("do not use single quote (') as special char!");
        }
        StringBuffer result = new StringBuffer(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('_');
                continue;
            }
            if (chr == multi) {
                result.append('%');
                continue;
            }
            if (chr == '\'') {
                result.append('\'');
                result.append('\'');
                continue;
            }
            result.append(chr);
        }
        return result.toString();
    }

    public String getSQL92LikePattern() throws IllegalArgumentException {
        if (this.escape.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> escape char should be of length exactly 1");
        }
        if (this.wildcardSingle.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardSingle char should be of length exactly 1");
        }
        if (this.wildcardMulti.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardMulti char should be of length exactly 1");
        }
        return LikeFilterImpl.convertToSQL92(this.escape.charAt(0), this.wildcardMulti.charAt(0), this.wildcardSingle.charAt(0), this.pattern);
    }

    public void setWildCard(String wildCard) {
        this.wildcardMulti = wildCard;
        this.match = null;
    }

    public void setSingleChar(String singleChar) {
        this.wildcardSingle = singleChar;
        this.match = null;
    }

    public void setEscape(String escape) {
        this.escape = escape;
        this.match = null;
    }

    private Matcher getMatcher() {
        if (this.match == null) {
            String pattern1 = new String(this.pattern);
            String wildcardMulti1 = new String(this.wildcardMulti);
            String wildcardSingle1 = new String(this.wildcardSingle);
            String escape1 = new String(this.escape);
            char esc = escape1.charAt(0);
            LOGGER.finer("wildcard " + wildcardMulti1 + " single " + wildcardSingle1);
            LOGGER.finer("escape " + escape1 + " esc " + esc + " esc == \\ " + (esc == '\\'));
            String escapedWildcardMulti = this.fixSpecials(wildcardMulti1);
            String escapedWildcardSingle = this.fixSpecials(wildcardSingle1);
            StringBuffer tmp = new StringBuffer("");
            boolean escapedMode = false;
            for (int i = 0; i < pattern1.length(); ++i) {
                char chr = pattern1.charAt(i);
                LOGGER.finer("tmp = " + tmp + " looking at " + chr);
                if (pattern1.regionMatches(false, i, escape1, 0, escape1.length())) {
                    LOGGER.finer("escape ");
                    escapedMode = true;
                    chr = pattern1.charAt(i += escape1.length());
                }
                if (pattern1.regionMatches(false, i, wildcardMulti1, 0, wildcardMulti1.length())) {
                    LOGGER.finer("multi wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardMulti);
                    } else {
                        tmp.append(".*");
                    }
                    i += wildcardMulti1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (pattern1.regionMatches(false, i, wildcardSingle1, 0, wildcardSingle1.length())) {
                    LOGGER.finer("single wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardSingle);
                    } else {
                        tmp.append(".{1}");
                    }
                    i += wildcardSingle1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (this.isSpecial(chr)) {
                    LOGGER.finer("special");
                    tmp.append(this.escape + chr);
                    escapedMode = false;
                    continue;
                }
                tmp.append(chr);
                escapedMode = false;
            }
            pattern1 = tmp.toString();
            LOGGER.finer("final pattern " + pattern1);
            this.compPattern = Pattern.compile(pattern1);
            this.match = this.compPattern.matcher("");
        }
        return this.match;
    }

    protected LikeFilterImpl() {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)20;
    }

    public final void setValue(Expression attribute) throws IllegalFilterException {
        this.setExpression(attribute);
    }

    public final Expression getValue() {
        return this.attribute;
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.getValue();
    }

    public void setExpression(org.opengis.filter.expression.Expression e) {
        Expression attribute = (Expression)e;
        if (attribute.getType() == 111 && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add something other than a string attribute expression to a like filter.");
        }
        this.attribute = attribute;
    }

    public final void setPattern(Expression p, String wildcardMulti, String wildcardSingle, String escape) {
        this.setPattern(p.toString(), wildcardMulti, wildcardSingle, escape);
    }

    public final void setPattern(String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    public final String getPattern() {
        return this.getLiteral();
    }

    public String getLiteral() {
        return this.pattern;
    }

    public void setLiteral(String literal) {
        this.pattern = literal;
        this.match = null;
    }

    public boolean evaluate(Object feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.attribute.evaluate(feature);
        if (null == value) {
            return false;
        }
        Matcher matcher = this.getMatcher();
        matcher.reset(this.attribute.evaluate(feature).toString());
        return matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " is like " + this.pattern + " ]";
    }

    public String getEscape() {
        return this.escape;
    }

    public final String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildCard() {
        return this.getWildcardMulti();
    }

    public final String getWildcardSingle() {
        return this.wildcardSingle;
    }

    public String getSingleChar() {
        return this.getWildcardSingle();
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    private String fixSpecials(String inString) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(this.escape + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return lFilter.getFilterType() == this.filterType && lFilter.getValue().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsLike)this, extraData);
    }
}

