/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataStore
extends AbstractDataStore {
    protected Map memory = new HashMap();
    protected Map schema = new HashMap();

    public MemoryDataStore() {
        super(true);
    }

    public MemoryDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.addFeatures(collection);
    }

    public MemoryDataStore(SimpleFeature[] array) {
        this.addFeatures(array);
    }

    public MemoryDataStore(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public MemoryDataStore(FeatureIterator<SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public void addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        try {
            LinkedHashMap<String, SimpleFeature> featureMap = new LinkedHashMap<String, SimpleFeature>();
            SimpleFeature feature = reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Problem using reader", (Throwable)((Object)e));
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureIterator<SimpleFeature> reader) throws IOException {
        try {
            HashMap<String, SimpleFeature> featureMap = new HashMap<String, SimpleFeature>();
            SimpleFeature feature = reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Provided FeatureCollection<SimpleFeatureType, SimpleFeature> is empty");
        }
        Map map = this.memory;
        synchronized (map) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                this.addFeatureInternal((SimpleFeature)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided FeatureCollection<SimpleFeatureType, SimpleFeature> is empty");
        }
        Map map = this.memory;
        synchronized (map) {
            try {
                collection.accepts(new FeatureVisitor(){

                    public void visit(Feature feature) {
                        MemoryDataStore.this.addFeatureInternal((SimpleFeature)feature);
                    }
                }, null);
            }
            catch (IOException ignore) {
                LOGGER.log(Level.FINE, "Unable to add all features", ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(SimpleFeature[] features) {
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException("Provided features are empty");
        }
        Map map = this.memory;
        synchronized (map) {
            for (int i = 0; i < features.length; ++i) {
                this.addFeatureInternal(features[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(SimpleFeature feature) {
        Map map = this.memory;
        synchronized (map) {
            this.addFeatureInternal(feature);
        }
    }

    private void addFeatureInternal(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        SimpleFeatureType featureType = feature.getFeatureType();
        String typeName = featureType.getTypeName();
        if (!this.memory.containsKey(typeName)) {
            try {
                this.createSchema(featureType);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Map featuresMap = (Map)this.memory.get(typeName);
        featuresMap.put(feature.getID(), feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map features(String typeName) throws IOException {
        Map map = this.memory;
        synchronized (map) {
            if (this.memory.containsKey(typeName)) {
                return (Map)this.memory.get(typeName);
            }
        }
        throw new IOException("Type name " + typeName + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTypeNames() {
        Map map = this.memory;
        synchronized (map) {
            String[] types = new String[this.schema.size()];
            int index = 0;
            Iterator i = this.schema.keySet().iterator();
            while (i.hasNext()) {
                types[index] = (String)i.next();
                ++index;
            }
            return types;
        }
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Map map = this.memory;
        synchronized (map) {
            if (this.schema.containsKey(typeName)) {
                return (SimpleFeatureType)this.schema.get(typeName);
            }
            throw new SchemaNotFoundException(typeName);
        }
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        if (this.memory.containsKey(typeName)) {
            throw new IOException(typeName + " already exists");
        }
        LinkedHashMap featuresMap = new LinkedHashMap();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featuresMap);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(final String typeName) throws IOException {
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){
            SimpleFeatureType featureType;
            Iterator iterator;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.iterator = MemoryDataStore.this.features(typeName).values().iterator();
            }

            @Override
            public SimpleFeatureType getFeatureType() {
                return this.featureType;
            }

            @Override
            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                if (this.iterator == null) {
                    throw new IOException("Feature Reader has been closed");
                }
                try {
                    return SimpleFeatureBuilder.copy((SimpleFeature)this.iterator.next());
                }
                catch (NoSuchElementException end) {
                    throw new DataSourceException("There are no more Features", end);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iterator != null && this.iterator.hasNext();
            }

            @Override
            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
            }
        };
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(final String typeName, final Transaction transaction) throws IOException {
        return new FeatureWriter<SimpleFeatureType, SimpleFeature>(){
            SimpleFeatureType featureType;
            Map contents;
            Iterator iterator;
            SimpleFeature live;
            SimpleFeature current;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.contents = MemoryDataStore.this.features(typeName);
                this.iterator = this.contents.values().iterator();
                this.live = null;
                this.current = null;
            }

            @Override
            public SimpleFeatureType getFeatureType() {
                return this.featureType;
            }

            @Override
            public SimpleFeature next() throws IOException, NoSuchElementException {
                if (this.hasNext()) {
                    this.live = (SimpleFeature)this.iterator.next();
                    try {
                        this.current = SimpleFeatureBuilder.copy(this.live);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + typeName);
                    }
                }
                this.live = null;
                try {
                    this.current = SimpleFeatureBuilder.template(this.featureType, null);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to add additional Features of " + typeName);
                }
                return this.current;
            }

            @Override
            public void remove() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to remove");
                }
                if (this.live != null) {
                    this.iterator.remove();
                    MemoryDataStore.this.listenerManager.fireFeaturesRemoved(typeName, transaction, new ReferencedEnvelope(this.live.getBounds()), true);
                    this.live = null;
                    this.current = null;
                } else {
                    this.current = null;
                }
            }

            @Override
            public void write() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to write");
                }
                if (this.live != null) {
                    if (this.live.equals(this.current)) {
                        this.live = null;
                        this.current = null;
                    } else {
                        try {
                            this.live.setAttributes(this.current.getAttributes());
                        }
                        catch (Exception e) {
                            throw new DataSourceException("Unable to accept modifications to " + this.live.getID() + " on " + typeName);
                        }
                        ReferencedEnvelope bounds = new ReferencedEnvelope();
                        bounds.expandToInclude(new ReferencedEnvelope(this.live.getBounds()));
                        bounds.expandToInclude(new ReferencedEnvelope(this.current.getBounds()));
                        MemoryDataStore.this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, true);
                        this.live = null;
                        this.current = null;
                    }
                } else {
                    this.contents.put(this.current.getID(), this.current);
                    MemoryDataStore.this.listenerManager.fireFeaturesAdded(typeName, transaction, new ReferencedEnvelope(this.current.getBounds()), true);
                    this.current = null;
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                return this.iterator != null && this.iterator.hasNext();
            }

            @Override
            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
                this.contents = null;
                this.current = null;
                this.live = null;
            }
        };
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map contents = this.features(typeName);
        Iterator iterator = contents.values().iterator();
        ReferencedEnvelope envelope = null;
        if (iterator.hasNext()) {
            int count = 1;
            Filter filter = query.getFilter();
            SimpleFeature first = (SimpleFeature)iterator.next();
            Envelope env = ((Geometry)first.getDefaultGeometry()).getEnvelopeInternal();
            envelope = new ReferencedEnvelope(env, first.getType().getCoordinateReferenceSystem());
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                if (!filter.evaluate((Object)feature)) continue;
                ++count;
                envelope.expandToInclude(((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal());
            }
        }
        return envelope;
    }

    @Override
    protected int getCount(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map contents = this.features(typeName);
        Iterator iterator = contents.values().iterator();
        int count = 0;
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.evaluate((Object)((SimpleFeature)iterator.next()))) continue;
            ++count;
        }
        return count;
    }
}

