/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.filter.v1_0.OGC;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class OGCPropertyIsLikeTypeBinding
extends AbstractComplexBinding {
    private FilterFactory factory;

    public OGCPropertyIsLikeTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return OGC.PropertyIsLikeType;
    }

    public Class getType() {
        return PropertyIsLike.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        PropertyName name = (PropertyName)node.getChildValue(PropertyName.class);
        Literal literal = (Literal)node.getChildValue(Literal.class);
        String wildcard = (String)node.getAttributeValue("wildCard");
        String single = (String)node.getAttributeValue("singleChar");
        String escape = (String)node.getAttributeValue("escape");
        if (escape == null) {
            escape = (String)node.getAttributeValue("escapeChar");
        }
        return this.factory.like((Expression)name, literal.toString(), wildcard, single, escape);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        PropertyIsLike isLike = (PropertyIsLike)object;
        if (OGC.PropertyName.equals(name)) {
            return isLike.getExpression();
        }
        if (OGC.Literal.equals(name)) {
            return isLike.getLiteral() != null ? this.factory.literal((Object)isLike.getLiteral()) : null;
        }
        if ("wildCard".equals(name.getLocalPart())) {
            return isLike.getWildCard();
        }
        if ("singleChar".equals(name.getLocalPart())) {
            return isLike.getSingleChar();
        }
        if ("escape".equals(name.getLocalPart()) || "escapeChar".equals(name.getLocalPart())) {
            return isLike.getEscape();
        }
        return null;
    }
}

