/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageFile
implements Comparable<StorageFile>,
FileWriter {
    private final ShpFiles shpFiles;
    private final File tempFile;
    private final ShpFileType type;

    public StorageFile(ShpFiles shpFiles, File tempFile, ShpFileType type) {
        this.shpFiles = shpFiles;
        this.tempFile = tempFile;
        this.type = type;
    }

    public File getFile() {
        return this.tempFile;
    }

    public FileChannel getWriteChannel() throws IOException {
        return new RandomAccessFile(this.tempFile, "rw").getChannel();
    }

    public void replaceOriginal() throws IOException {
        StorageFile.replaceOriginals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceOriginals(StorageFile ... storageFiles) throws IOException {
        TreeSet<StorageFile> files = new TreeSet<StorageFile>(Arrays.asList(storageFiles));
        ShpFiles currentShpFiles = null;
        URL shpURL = null;
        StorageFile locker = null;
        for (StorageFile storageFile : files) {
            if (currentShpFiles != storageFile.shpFiles) {
                StorageFile.unlock(currentShpFiles, shpURL, locker);
                locker = storageFile;
                currentShpFiles = storageFile.shpFiles;
                shpURL = currentShpFiles.acquireWrite(ShpFileType.SHP, storageFile);
            }
            File storage = storageFile.getFile();
            URL url = storageFile.getSrcURLForWrite();
            try {
                File dest = DataUtilities.urlToFile(url);
                if (storage.equals(dest)) {
                    return;
                }
                if (dest.exists() && !dest.delete()) {
                    ShapefileDataStoreFactory.LOGGER.severe("Unable to delete the file: " + dest + " when attempting to replace with temporary copy.");
                    if (storageFile.shpFiles.numberOfLocks() > 0) {
                        ShapefileDataStoreFactory.LOGGER.severe("The problem is almost certainly caused by the fact that there are still locks being held on the shapefiles.  Probably a reader or writer was left unclosed");
                        storageFile.shpFiles.logCurrentLockers(Level.SEVERE);
                    }
                }
                if (!storage.exists() || storage.renameTo(dest)) continue;
                ShapefileDataStoreFactory.LOGGER.finer("Unable to rename temporary file to the file: " + dest + " when attempting to replace with temporary copy");
                StorageFile.copyFile(storage, url, dest);
                if (storage.delete()) continue;
                storage.deleteOnExit();
            }
            finally {
                storageFile.unlockWriteURL(url);
                if (!storage.exists()) continue;
                storage.delete();
            }
        }
        StorageFile.unlock(currentShpFiles, shpURL, locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File storage, URL url, File dest) throws FileNotFoundException, IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(storage).getChannel();
            out = new FileOutputStream(dest).getChannel();
            int maxCount = 67076096;
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, maxCount, (WritableByteChannel)((Object)out))) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private URL getSrcURLForWrite() {
        return this.shpFiles.acquireWrite(this.type, this);
    }

    private void unlockWriteURL(URL url) {
        this.shpFiles.unlockWrite(url, (FileWriter)this);
    }

    private static void unlock(ShpFiles currentShpFiles, URL shpURL, StorageFile locker) {
        if (currentShpFiles == null) {
            return;
        }
        currentShpFiles.unlockWrite(shpURL, (FileWriter)locker);
    }

    @Override
    public int compareTo(StorageFile o) {
        if (this == o) {
            return 0;
        }
        if (!this.shpFiles.equals(o.shpFiles)) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.id();
    }

    @Override
    public String id() {
        return this.getClass().getSimpleName() + ": " + this.tempFile.getName();
    }
}

