/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockServletInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Message;
import org.geoserver.ows.Request;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DispatcherTest
extends TestCase {
    public void testReadOpContext() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Map map = dispatcher.readOpContext((HttpServletRequest)request);
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
        DispatcherTest.assertNull(map.get("request"));
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello/Hello");
        request.setMethod("get");
        map = dispatcher.readOpContext((HttpServletRequest)request);
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello/Hello/");
        request.setMethod("get");
        map = dispatcher.readOpContext((HttpServletRequest)request);
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
        DispatcherTest.assertEquals((Object)"Hello", map.get("request"));
    }

    public void testReadOpPost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String body = "<Hello service=\"hello\"/>";
        MockServletInputStream input = new MockServletInputStream(body.getBytes());
        Dispatcher dispatcher = new Dispatcher();
        BufferedReader buffered = new BufferedReader(new InputStreamReader((InputStream)input));
        buffered.mark(2048);
        Map map = dispatcher.readOpPost(buffered);
        DispatcherTest.assertNotNull((Object)map);
        DispatcherTest.assertEquals((Object)"Hello", map.get("request"));
        DispatcherTest.assertEquals((Object)"hello", map.get("service"));
    }

    public void testParseKVP() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setupAddParameter("service", "hello");
        request.setupAddParameter("request", "Hello");
        request.setupAddParameter("message", "Hello world!");
        request.setQueryString("service=hello&request=hello&message=Hello World!");
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.parseKVP(req);
        Message message = (Message)dispatcher.parseRequestKVP(Message.class, req);
        DispatcherTest.assertEquals((Object)new Message("Hello world!"), (Object)message);
    }

    public void testParseXML() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\"/>";
        File file = File.createTempFile("geoserver", "req");
        file.deleteOnExit();
        FileOutputStream output = new FileOutputStream(file);
        output.write(body.getBytes());
        output.flush();
        output.close();
        BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        input.mark(8192);
        Request req = new Request();
        req.input = input;
        Object object = dispatcher.parseRequestXML(null, input, req);
        DispatcherTest.assertEquals((Object)new Message("Hello world!"), (Object)object);
    }

    public void testHelloOperationGet() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setupAddParameter("service", "hello");
        request.setupAddParameter("request", "Hello");
        request.setupAddParameter("version", "1.0.0");
        request.setupAddParameter("message", "Hello world!");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getOutputStreamContent());
    }

    public void testHelloOperationPost() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }

            public ServletInputStream getInputStream() throws IOException {
                final ServletInputStream stream = super.getInputStream();
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return stream.read();
                    }

                    public int available() {
                        return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                    }
                };
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        request.setRequestURI("http://localhost/geoserver/ows");
        request.setContentType("application/xml");
        request.setBodyContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getOutputStreamContent());
    }

    public void testHelloOperationMixed() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContextOnlyXml.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }

            public ServletInputStream getInputStream() throws IOException {
                final ServletInputStream stream = super.getInputStream();
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return stream.read();
                    }

                    public int available() {
                        return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                    }
                };
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("POST");
        request.setRequestURI("http://localhost/geoserver/ows");
        request.setContentType("application/xml");
        request.setBodyContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setupAddParameter("strict", "true");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((String)"Hello world!", (String)response.getOutputStreamContent());
    }

    public void testHttpErrorCodeException() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("applicationContext.xml");
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());
        Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        request.setupAddParameter("service", "hello");
        request.setupAddParameter("request", "httpErrorCodeException");
        request.setupAddParameter("version", "1.0.0");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        DispatcherTest.assertEquals((int)204, (int)response.getStatusCode());
    }
}

