/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.geotools.util.logging.Logging;

final class ReferenceCleaner
extends Thread {
    public static final ReferenceCleaner DEFAULT = new ReferenceCleaner();
    final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    private ReferenceCleaner() {
        super("WeakCollectionCleaner");
        this.setPriority(8);
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        while (this.referenceQueue != null) {
            try {
                Reference<Object> ref = this.referenceQueue.remove();
                if (ref == null) {
                    ReferenceCleaner.sleep(15000L);
                    break;
                }
                ref.clear();
            }
            catch (InterruptedException exception) {
            }
            catch (Exception exception) {
                Logging.unexpectedException(ReferenceCleaner.class, (String)"remove", (Throwable)exception);
            }
            catch (AssertionError exception) {
                Logging.unexpectedException(ReferenceCleaner.class, (String)"remove", (Throwable)((Object)exception));
            }
        }
        Logging.getLogger(ReferenceCleaner.class).severe("Daemon stopped.");
    }
}

