/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.servlets;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.kvp.GetMapKvpRequestReader;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.requests.GetKMLReflectKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.WMService;

public class KMLReflector
extends WMService {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.servlets");
    final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml";
    final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz+xml";
    org.vfny.geoserver.wms.responses.map.kml.KMLReflector delegate;

    public KMLReflector() {
        super("kml_reflect", null);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setWMS((WMS)((Object)config.getServletContext().getAttribute("WMS")));
        this.delegate = (org.vfny.geoserver.wms.responses.map.kml.KMLReflector)GeoServerExtensions.bean((String)"kmlService");
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new GetKMLReflectKvpReader(params, this.getWMS());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GetMapKvpRequestReader requestReader = new GetMapKvpRequestReader(this.getWMS());
        requestReader.setHttpRequest(request);
        GetMapRequest serviceRequest = null;
        try {
            serviceRequest = (GetMapRequest)((Object)requestReader.createRequest());
            KvpMap parsedKvp = KvpUtils.normalize((Map)request.getParameterMap());
            KvpMap rawKvp = new KvpMap((Map)parsedKvp);
            serviceRequest = (GetMapRequest)((Object)requestReader.read((Object)serviceRequest, (Map)parsedKvp, (Map)rawKvp));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure while trying to parse KML reflector request", e);
            if (e instanceof ServiceException) {
                throw (ServiceException)((Object)e);
            }
            throw new ServiceException((Throwable)e);
        }
        try {
            this.delegate.wms(serviceRequest, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

