/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.metatile;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.WatermarkPainter;
import org.vfny.geoserver.wms.responses.map.metatile.QuickTileCache;

public class MetatileWatermarkPainter
extends WatermarkPainter {
    private QuickTileCache.MetaTileKey key;

    public MetatileWatermarkPainter(QuickTileCache.MetaTileKey key, GetMapRequest request) {
        super(request);
        this.key = key;
    }

    public void paint(Graphics2D g2d, Rectangle paintArea) throws MalformedURLException, ClassCastException, IOException {
        BufferedImage logo = this.getLogo();
        if (logo != null) {
            int metaFactor = this.key.getMetaFactor();
            int tileSize = this.key.getTileSize();
            for (int i = 0; i < metaFactor; ++i) {
                for (int j = 0; j < metaFactor; ++j) {
                    int x = tileSize * i;
                    int y = tileSize * j;
                    Rectangle tileArea = new Rectangle(x, y, tileSize, tileSize);
                    WMS wms = this.request.getWMS();
                    this.paintLogo(g2d, logo, tileArea, wms.getWatermarkTransparency(), wms.getWatermarkPosition());
                }
            }
        }
    }
}

