/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.metatile;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.operator.CropDescriptor;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileWatermarkPainter;
import org.vfny.geoserver.wms.responses.map.metatile.QuickTileCache;

public final class MetatileMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.metatile");
    public static final double EPS = 1.0E-6;
    private GetMapRequest request;
    private RasterMapProducer delegate;
    private RenderedImage tile;
    private static QuickTileCache tileCache;

    public static boolean isRequestTiled(GetMapRequest request, GetMapProducer delegate) {
        return request.isTiled() && request.getTilesOrigin() != null && request.getWidth() == 256 && request.getHeight() == 256 && delegate instanceof RasterMapProducer;
    }

    public MetatileMapProducer(GetMapRequest request, RasterMapProducer delegate) {
        if (tileCache == null) {
            tileCache = (QuickTileCache)GeoServerExtensions.bean((String)"metaTileCache");
        }
        this.request = request;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceMap() throws WmsException {
        QuickTileCache.MetaTileKey key;
        QuickTileCache.MetaTileKey metaTileKey = key = tileCache.getMetaTileKey(this.request);
        synchronized (metaTileKey) {
            this.tile = tileCache.getTile(key, this.request);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Looked for meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y + "in cache: " + (this.tile != null ? "hit!" : "miss"));
            }
            if (this.tile == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Building meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y);
                }
                ReferencedEnvelope origEnv = this.mapContext.getAreaOfInterest();
                this.mapContext.setAreaOfInterest(new ReferencedEnvelope(key.getMetaTileEnvelope(), origEnv.getCoordinateReferenceSystem()));
                this.mapContext.setMapWidth(key.getTileSize() * key.getMetaFactor());
                this.mapContext.setMapHeight(key.getTileSize() * key.getMetaFactor());
                this.delegate.setMapContext(this.mapContext);
                if (this.delegate instanceof DefaultRasterMapProducer) {
                    ((DefaultRasterMapProducer)this.delegate).setWmPainter(new MetatileWatermarkPainter(key, this.request));
                }
                this.delegate.produceMap();
                RenderedImage metaTile = this.delegate.getImage();
                RenderedImage[] tiles = this.split(key, metaTile, this.mapContext);
                tileCache.storeTiles(key, tiles);
                this.tile = tileCache.getTile(key, this.request, tiles);
            }
        }
    }

    private RenderedImage[] split(QuickTileCache.MetaTileKey key, RenderedImage metaTile, WMSMapContext map) {
        int metaFactor = key.getMetaFactor();
        RenderedImage[] tiles = new RenderedImage[key.getMetaFactor() * key.getMetaFactor()];
        int tileSize = key.getTileSize();
        RenderingHints no_cache = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        for (int i = 0; i < metaFactor; ++i) {
            for (int j = 0; j < metaFactor; ++j) {
                int x = j * tileSize;
                int y = tileSize * (metaFactor - 1) - i * tileSize;
                tiles[i * key.getMetaFactor() + j] = this.tile = CropDescriptor.create((RenderedImage)metaTile, (Float)new Float(x), (Float)new Float(y), (Float)new Float(tileSize), (Float)new Float(tileSize), (RenderingHints)no_cache);
            }
        }
        return tiles;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.delegate.formatImageOutputStream(this.tile, out);
    }

    public void abort() {
        this.delegate.abort();
    }

    public String getContentDisposition() {
        return this.delegate.getContentDisposition();
    }

    public String getContentType() throws IllegalStateException {
        return this.delegate.getContentType();
    }
}

