/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.SelectedChannelType;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.PackagedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorMapLegendBuilder {
    private static final Logger LOGGER = Logging.getLogger(ColorMapLegendBuilder.class);
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private ColorMapType colorMapType;
    private boolean extended = false;
    private boolean transparent;
    private Dimension requestedDimension;
    private Map<String, ?> additionalOptions;
    private Color backgroundColor;
    private Font labelFont;
    private Color labelFontColor;
    private ColorMapEntry previousCMapEntry;
    private final Queue<ColorMapEntryLegendBuilder> bodyRows = new LinkedList<ColorMapEntryLegendBuilder>();
    private final List<Cell> footerRows = new ArrayList<Cell>();
    private LegendUtils.HAlign hAlign = LegendUtils.HAlign.LEFT;
    private LegendUtils.VAlign vAlign = LegendUtils.VAlign.BOTTOM;
    private double vMarginPercentage = 0.015f;
    private double hMarginPercentage = 0.015f;
    private double rowMarginPercentage = 0.15f;
    private double columnMarginPercentage = 0.15f;
    private Color borderColor = LegendUtils.DEFAULT_BORDER_COLOR;
    private boolean borderLabel = false;
    private boolean borderRule = false;
    private double dx;
    private double dy;
    private double margin;
    private double rowH;
    private double colorW;
    private double ruleW;
    private double labelW;
    private double footerW;
    private String grayChannelName = "1";
    private boolean fontAntiAliasing = true;
    private boolean forceRule = false;
    private BufferedImage legend;
    private boolean border = false;

    ColorMapLegendBuilder() {
    }

    private void checkFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("The builder is frozen you can't change it anymore!");
        }
    }

    public ColorMapType getColorMapType() {
        return this.colorMapType;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public void setColorMapType(int type) {
        this.colorMapType = ColorMapType.create(type);
    }

    public void addColorMapEntry(ColorMapEntry cEntry) {
        ColorMapEntryLegendBuilder element;
        this.checkFrozen();
        PackagedUtils.ensureNotNull(cEntry, "cEntry");
        switch (this.colorMapType) {
            case UNIQUE_VALUES: {
                element = new SingleColorMapEntryLegendBuilder(Arrays.asList(cEntry), this.hAlign, this.vAlign);
                break;
            }
            case RAMP: {
                element = new RampColorMapEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign);
                break;
            }
            case CLASSES: {
                element = new ClassesEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized colormap type");
            }
        }
        this.bodyRows.add(element);
        this.previousCMapEntry = cEntry;
    }

    public void setRequestedDimension(Dimension dimension) {
        this.checkFrozen();
        this.requestedDimension = (Dimension)dimension.clone();
    }

    public void setTransparent(boolean transparent) {
        this.checkFrozen();
        this.transparent = transparent;
    }

    public synchronized BufferedImage getLegend() {
        if (this.legend == null) {
            this.frozen.set(true);
            this.init();
            Queue<BufferedImage> body = this.createBody();
            Queue<BufferedImage> footer = this.createFooter();
            body.addAll(footer);
            this.legend = this.mergeRows(body);
        }
        return this.legend;
    }

    private void init() {
        this.checkAdditionalOptions();
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap hintsMap = new HashMap();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        this.rowH = Double.NEGATIVE_INFINITY;
        this.colorW = Double.NEGATIVE_INFINITY;
        this.ruleW = Double.NEGATIVE_INFINITY;
        this.labelW = Double.NEGATIVE_INFINITY;
        this.cycleBodyRows(graphics);
        String bandNameString = "Band selection is " + this.grayChannelName;
        this.footerRows.add(new TextManager(bandNameString, LegendUtils.VAlign.BOTTOM, LegendUtils.HAlign.LEFT));
        String colorMapTypeString = "ColorMap type is " + this.colorMapType.toString();
        this.footerRows.add(new TextManager(colorMapTypeString, LegendUtils.VAlign.BOTTOM, LegendUtils.HAlign.LEFT));
        String extendedCMapString = "ColorMap is " + (this.extended ? "" : "not") + " extended";
        this.footerRows.add(new TextManager(extendedCMapString, LegendUtils.VAlign.BOTTOM, LegendUtils.HAlign.LEFT));
        this.cycleFooterRows(graphics);
        double maxW = Math.max(Math.max(Math.max(this.colorW, this.ruleW), this.labelW), this.footerW);
        this.dx = maxW * this.columnMarginPercentage;
        this.dy = this.colorMapType == ColorMapType.RAMP ? 0.0 : this.rowH * this.rowMarginPercentage;
        double mx = maxW * this.hMarginPercentage;
        double my = this.rowH * this.vMarginPercentage;
        this.margin = Math.max(mx, my);
    }

    private void checkAdditionalOptions() {
        String aaVal;
        this.fontAntiAliasing = false;
        if (this.additionalOptions.get("fontAntiAliasing") instanceof String && ((aaVal = (String)this.additionalOptions.get("fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase("1"))) {
            this.fontAntiAliasing = true;
        }
        if (this.additionalOptions.get("dx") instanceof String) {
            this.columnMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("dx"));
        }
        if (this.additionalOptions.get("dy") instanceof String) {
            this.rowMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("dy"));
        }
        if (this.additionalOptions.get("mx") instanceof String) {
            this.hMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("mx"));
        }
        if (this.additionalOptions.get("my") instanceof String) {
            this.vMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("my"));
        }
        if (this.additionalOptions.get("borderColor") instanceof String) {
            this.borderColor = LegendUtils.color((String)this.additionalOptions.get("borderColor"));
        }
        if (this.additionalOptions.get("border") instanceof String) {
            this.border = Boolean.valueOf((String)this.additionalOptions.get("border"));
        }
        if (this.additionalOptions.get("forceRule") instanceof String) {
            this.forceRule = Boolean.parseBoolean((String)this.additionalOptions.get("forceRule"));
        }
        if (!this.forceRule) {
            for (ColorMapEntryLegendBuilder row : this.bodyRows) {
                Cell labelM = row.getLabelManager();
                if (labelM == null) {
                    this.forceRule = true;
                    continue;
                }
                this.forceRule = false;
                break;
            }
        }
    }

    private void cycleFooterRows(Graphics2D graphics) {
        int numRows = this.footerRows.size();
        int i = 0;
        this.footerW = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numRows; ++i) {
            Cell cell = this.footerRows.get(i);
            Dimension cellDim = cell.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, cellDim.getHeight());
            this.footerW = Math.max(this.footerW, cellDim.getWidth());
        }
    }

    private void cycleBodyRows(Graphics2D graphics) {
        for (ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell labelM;
            Cell cm = row.getColorManager();
            Dimension colorDim = cm.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, colorDim.getHeight());
            this.colorW = Math.max(this.colorW, colorDim.getWidth());
            if (this.forceRule) {
                Cell ruleM = row.getRuleManager();
                Dimension ruleDim = ruleM.getPreferredDimension(graphics);
                this.rowH = Math.max(this.rowH, ruleDim.getHeight());
                this.ruleW = Math.max(this.ruleW, ruleDim.getWidth());
            }
            if ((labelM = row.getLabelManager()) == null) continue;
            Dimension labelDim = labelM.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, labelDim.getHeight());
            this.labelW = Math.max(this.labelW, labelDim.getWidth());
        }
    }

    private Queue<BufferedImage> createFooter() {
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap hintsMap = new HashMap();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        LinkedList<BufferedImage> queue = new LinkedList<BufferedImage>();
        int rowHeight = (int)Math.round(this.rowH);
        int rowWidth = (int)Math.round(this.footerW);
        Rectangle clipboxA = new Rectangle(0, 0, rowWidth, rowHeight);
        for (Cell cell : this.footerRows) {
            BufferedImage colorCellLegend = new BufferedImage(rowWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            cell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            queue.add(colorCellLegend);
        }
        graphics.dispose();
        return queue;
    }

    private Queue<BufferedImage> createBody() {
        LinkedList<BufferedImage> queue = new LinkedList<BufferedImage>();
        int rowHeight = (int)Math.round(this.rowH);
        int colorWidth = (int)Math.round(this.colorW);
        int ruleWidth = (int)Math.round(this.ruleW);
        int labelWidth = (int)Math.round(this.labelW);
        Rectangle clipboxA = new Rectangle(0, 0, colorWidth, rowHeight);
        Rectangle clipboxB = new Rectangle(0, 0, ruleWidth, rowHeight);
        Rectangle clipboxC = new Rectangle(0, 0, labelWidth, rowHeight);
        for (ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell colorCell = row.getColorManager();
            BufferedImage colorCellLegend = new BufferedImage(colorWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            colorCell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            BufferedImage ruleCellLegend = null;
            if (this.forceRule) {
                Cell ruleCell = row.getRuleManager();
                ruleCellLegend = new BufferedImage(ruleWidth, rowHeight, 2);
                rlg = ruleCellLegend.createGraphics();
                rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ruleCell.draw(rlg, clipboxB, this.borderRule);
                rlg.dispose();
            }
            if (labelWidth > 0) {
                Cell labelCell = row.getLabelManager();
                BufferedImage labelCellLegend = new BufferedImage(labelWidth, rowHeight, 2);
                rlg = labelCellLegend.createGraphics();
                rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                labelCell.draw(rlg, clipboxC, this.borderLabel);
                rlg.dispose();
                HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, labelCellLegend, hintsMap, this.transparent, this.backgroundColor, this.dx));
                continue;
            }
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, null, hintsMap, this.transparent, this.backgroundColor, this.dx));
        }
        return queue;
    }

    private BufferedImage mergeRows(Queue<BufferedImage> legendsQueue) {
        Dimension finalDimension = new Dimension();
        int numRows = legendsQueue.size();
        finalDimension.setSize(Math.max(this.footerW, this.colorW + this.ruleW + this.labelW) + 2.0 * this.dx + 2.0 * this.margin, this.rowH * (double)numRows + 2.0 * this.margin + (double)(numRows - 1) * this.dy);
        int totalWidth = (int)finalDimension.getWidth();
        int totalHeight = (int)finalDimension.getHeight();
        BufferedImage finalLegend = ImageUtils.createImage(totalWidth, totalHeight, null, this.transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D finalGraphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, finalLegend, hintsMap);
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        finalGraphics.setRenderingHints(hintsMap);
        int topOfRow = (int)(this.margin + 0.5);
        for (int i = 0; i < numRows; ++i) {
            BufferedImage img = legendsQueue.remove();
            finalGraphics.drawImage((Image)img, (int)(this.margin + 0.5), topOfRow, null);
            topOfRow = (int)((double)topOfRow + ((double)img.getHeight() + this.dy));
        }
        finalGraphics.dispose();
        return finalLegend;
    }

    public void setAdditionalOptions(Map<String, List<String>> legendOptions) {
        this.checkFrozen();
        this.additionalOptions = new HashMap<String, List<String>>(legendOptions);
    }

    public Object getRequestedDimension() {
        return this.requestedDimension;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public Map<String, ?> getAdditionalOptions() {
        return Collections.unmodifiableMap(this.additionalOptions);
    }

    public void setColorMapType(ColorMapType colorMapType) {
        this.colorMapType = colorMapType;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backGroundColor) {
        this.checkFrozen();
        PackagedUtils.ensureNotNull(backGroundColor, "backGroundColor");
        this.backgroundColor = backGroundColor;
    }

    public void setLabelFont(Font labelFont) {
        this.checkFrozen();
        PackagedUtils.ensureNotNull(labelFont, "labelFont");
        this.labelFont = labelFont;
    }

    public void setLabelFontColor(Color labelFontColor) {
        this.checkFrozen();
        PackagedUtils.ensureNotNull(labelFontColor, "labelFontColor");
        this.labelFontColor = labelFontColor;
    }

    public void setBand(SelectedChannelType grayChannel) {
        this.checkFrozen();
        if (grayChannel != null) {
            this.grayChannelName = grayChannel.getChannelName();
        }
        if (this.grayChannelName == null) {
            this.grayChannelName = "1";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassesEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling) {
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new SimpleColorManager(color, opacity));
            String label = currentCME.getLabel();
            double quantity1 = leftEdge ? LegendUtils.getQuantity(currentCME) : LegendUtils.getQuantity(previousCME);
            double quantity2 = LegendUtils.getQuantity(currentCME);
            String symbol1 = null;
            String symbol2 = null;
            if (leftEdge) {
                symbol1 = " < ";
            } else {
                symbol1 = " <= ";
                symbol2 = " < ";
            }
            String rule = leftEdge ? Double.toString(quantity1) + " " + symbol1 + " x" : Double.toString(quantity1) + " " + symbol1 + " x " + symbol2 + " " + Double.toString(quantity2);
            super.add(new TextManager(rule, vAling, hAlign));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign));
            } else {
                super.add(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RampColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling) {
            Color previousColor;
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            if (!leftEdge) {
                previousColor = LegendUtils.color(previousCME);
                double opacity = LegendUtils.getOpacity(previousCME);
                previousColor = new Color(previousColor.getRed(), previousColor.getGreen(), previousColor.getBlue(), (int)(255.0 * opacity + 0.5));
            } else {
                previousColor = null;
            }
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new GradientColorManager(color, opacity, previousColor));
            String label = currentCME.getLabel();
            double quantity = LegendUtils.getQuantity(currentCME);
            String symbol = leftEdge ? " > " : " = ";
            String rule = leftEdge ? Double.toString(quantity) + " " + symbol + " x" : Double.toString(quantity) + " " + symbol + " x";
            super.add(new TextManager(rule, vAling, hAlign));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign));
            } else {
                super.add(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling) {
            ColorMapEntry currentCME = cMapEntries.get(0);
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new SimpleColorManager(color, opacity));
            String label = currentCME.getLabel();
            double quantity = LegendUtils.getQuantity(currentCME);
            String symbol = " = ";
            String rule = Double.toString(quantity) + " " + " = " + " x";
            super.add(new TextManager(rule, vAling, hAlign));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign));
            } else {
                super.add(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ColorMapEntryLegendBuilder
    extends Row {
        protected boolean hasLabel;

        protected ColorMapEntryLegendBuilder() {
        }

        protected ColorMapEntryLegendBuilder(List<Cell> columns) {
            super(columns);
        }

        protected ColorMapEntryLegendBuilder(ColorManager colorManager, TextManager labelManager, TextManager ruleManager) {
            super(Arrays.asList(colorManager, ruleManager, labelManager));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Cell getRuleManager() {
            return this.get(1);
        }

        public Cell getLabelManager() {
            return this.get(2);
        }

        public Cell getColorManager() {
            return this.get(0);
        }
    }

    class TextManager
    extends Cell {
        public TextManager(String text, LegendUtils.VAlign vAlign, LegendUtils.HAlign hAlign) {
            super(ColorMapLegendBuilder.this.backgroundColor, 1.0, text, vAlign, hAlign);
        }

        public Dimension getPreferredDimension(Graphics2D graphics) {
            Font oldFont = graphics.getFont();
            graphics.setFont(ColorMapLegendBuilder.this.labelFont);
            int labelHeight = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getHeight());
            int labelWidth = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getWidth());
            graphics.setFont(oldFont);
            return new Dimension(labelWidth, labelHeight);
        }

        public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
            int yText;
            int xText;
            Font oldFont = graphics.getFont();
            graphics.setColor(ColorMapLegendBuilder.this.labelFontColor);
            graphics.setFont(ColorMapLegendBuilder.this.labelFont);
            if (ColorMapLegendBuilder.this.fontAntiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            double minx = clipBox.getMinX();
            double miny = clipBox.getMinY();
            double w = clipBox.getWidth();
            double h = clipBox.getHeight();
            Dimension dimension = this.getPreferredDimension(graphics);
            switch (ColorMapLegendBuilder.this.hAlign) {
                case CENTERED: {
                    xText = (int)(minx + (w - dimension.getWidth()) / 2.0 + 0.5);
                    break;
                }
                case LEFT: {
                    xText = (int)(minx + 0.5);
                    break;
                }
                case RIGHT: {
                    xText = (int)(minx + (w - dimension.getWidth()) + 0.5);
                    break;
                }
                case JUSTIFIED: {
                    throw new UnsupportedOperationException("Unsupported");
                }
                default: {
                    throw new IllegalStateException("Unsupported horizontal alignment " + (Object)((Object)ColorMapLegendBuilder.this.hAlign));
                }
            }
            switch (ColorMapLegendBuilder.this.vAlign) {
                case BOTTOM: {
                    yText = (int)(miny + h - (double)graphics.getFontMetrics().getDescent() + 0.5);
                    break;
                }
                case TOP: {
                    yText = (int)(miny + (double)graphics.getFontMetrics().getHeight() + 0.5);
                    break;
                }
                case MIDDLE: {
                    yText = (int)(miny + (h + (double)graphics.getFontMetrics().getHeight()) / 2.0 + 0.5);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported vertical alignment " + (Object)((Object)ColorMapLegendBuilder.this.vAlign));
                }
            }
            graphics.drawString(this.text, xText, yText);
            graphics.setFont(oldFont);
        }
    }

    class GradientColorManager
    extends SimpleColorManager {
        private Color previousColor;
        private boolean leftEdge;

        public Dimension getPreferredDimension(Graphics2D graphics) {
            return new Dimension(((ColorMapLegendBuilder)ColorMapLegendBuilder.this).requestedDimension.width, (int)(1.5 * (double)((ColorMapLegendBuilder)ColorMapLegendBuilder.this).requestedDimension.height + 0.5));
        }

        public GradientColorManager(Color color, double opacity, Color previousColor) {
            super(color, opacity);
            this.previousColor = null;
            this.previousColor = previousColor;
            if (previousColor == null) {
                this.leftEdge = true;
            }
        }

        public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
            Rectangle2D.Double rectLegend;
            double minx = clipBox.getMinX();
            double miny = clipBox.getMinY();
            double w = clipBox.getWidth();
            double h = clipBox.getHeight();
            if (!this.leftEdge) {
                rectLegend = new Rectangle2D.Double(minx, miny, w, h / 2.0);
                Paint oldPaint = graphics.getPaint();
                GradientPaint paint = new GradientPaint((float)minx, (float)miny, this.previousColor, (float)minx, (float)(miny + h / 2.0), this.bkgColor);
                graphics.setPaint(paint);
                graphics.fill(rectLegend);
                graphics.setPaint(oldPaint);
            }
            rectLegend = new Rectangle2D.Double(minx, miny + (this.leftEdge ? 0.0 : h / 2.0), w, !this.leftEdge ? h / 2.0 : h);
            super.draw(graphics, rectLegend, completeBorder);
            if (!completeBorder) {
                Color oldColor = graphics.getColor();
                graphics.setColor(ColorMapLegendBuilder.this.borderColor);
                int minx_ = (int)(clipBox.getMinX() + 0.5);
                int maxx = (int)(minx + clipBox.getWidth() + 0.5) - 1;
                int maxy = (int)(miny + clipBox.getHeight() + 0.5) - 1;
                graphics.drawLine(minx_, maxy, maxx, maxy);
                graphics.setColor(oldColor);
            }
        }
    }

    class SimpleColorManager
    extends ColorManager {
        public SimpleColorManager(Color color, double opacity) {
            super(color, opacity);
        }

        public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
            if (this.bkgOpacity > 0.0) {
                Color oldColor = graphics.getColor();
                Color newColor = new Color(this.bkgColor.getRed(), this.bkgColor.getGreen(), this.bkgColor.getBlue(), (int)(255.0 * this.bkgOpacity + 0.5));
                graphics.setColor(newColor);
                graphics.fill(clipBox);
                graphics.setColor(ColorMapLegendBuilder.this.borderColor);
                if (completeBorder) {
                    int minx = (int)(clipBox.getMinX() + 0.5);
                    int miny = (int)(clipBox.getMinY() + 0.5);
                    int w = (int)(clipBox.getWidth() + 0.5) - 1;
                    int h = (int)(clipBox.getHeight() + 0.5) - 1;
                    graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                }
                graphics.setColor(oldColor);
            } else {
                Color oldColor = graphics.getColor();
                graphics.setColor(Color.white);
                graphics.fill(clipBox);
                graphics.setColor(Color.RED);
                int minx = (int)(clipBox.getMinX() + 0.5);
                int miny = (int)(clipBox.getMinY() + 0.5);
                int maxx = (int)((double)minx + clipBox.getWidth() - 1.0 + 0.5);
                int maxy = (int)((double)miny + clipBox.getHeight() - 1.0 + 0.5);
                graphics.drawLine(minx, miny, maxx, maxy);
                graphics.drawLine(minx, maxy, maxx, miny);
                graphics.setColor(Color.BLACK);
                if (completeBorder) {
                    int w = (int)(clipBox.getWidth() + 0.5) - 1;
                    int h = (int)(clipBox.getHeight() + 0.5) - 1;
                    graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                }
                graphics.setColor(oldColor);
            }
        }
    }

    abstract class ColorManager
    extends Cell {
        public ColorManager(Color color, double opacity) {
            super(color, opacity, null, null, null);
        }

        public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

        public Dimension getPreferredDimension(Graphics2D graphics) {
            return new Dimension(ColorMapLegendBuilder.this.requestedDimension);
        }
    }

    abstract class Cell {
        protected final Color bkgColor;
        protected final double bkgOpacity;
        protected final String text;
        protected final LegendUtils.VAlign textVAlign;
        protected final LegendUtils.HAlign textHAlign;

        public Cell(Color bkgColor, double bkgOpacity, String text, LegendUtils.VAlign vAlign, LegendUtils.HAlign hAlign) {
            this.bkgOpacity = bkgOpacity;
            this.bkgColor = bkgColor;
            this.text = text;
            this.textVAlign = vAlign;
            this.textHAlign = hAlign;
        }

        public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

        public abstract Dimension getPreferredDimension(Graphics2D var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Row {
        private final List<Cell> cells = new ArrayList<Cell>();

        Row() {
        }

        Row(List<Cell> columns) {
            columns.addAll(columns);
        }

        protected Cell get(int index) {
            return this.cells.get(index);
        }

        protected void add(Cell cell) {
            this.cells.add(cell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ColorMapType {
        UNIQUE_VALUES,
        RAMP,
        CLASSES;


        public static ColorMapType create(String value) {
            if (value.equalsIgnoreCase("intervals")) {
                return CLASSES;
            }
            if (value.equalsIgnoreCase("ramp")) {
                return RAMP;
            }
            if (value.equalsIgnoreCase("values")) {
                return UNIQUE_VALUES;
            }
            return ColorMapType.valueOf(value);
        }

        public static ColorMapType create(int value) {
            switch (value) {
                case 2: {
                    return CLASSES;
                }
                case 1: {
                    return RAMP;
                }
                case 3: {
                    return UNIQUE_VALUES;
                }
            }
            throw new IllegalArgumentException("Unable to create ColorMapType for value " + value);
        }
    }
}

