/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.MetaRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private boolean textStorage;
    private int block;
    private int blockCount;
    private int storageId;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean lobFilesInDirectories;

    private void showUsage() {
        this.out.println("Helps recovering a corrupted database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-dir <dir>]      The directory (default: .)\n" + " [-db <database>]  The database name\n" + " [-trace]          Print additional trace information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new Recover().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                bl = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string3);
            this.showUsage();
            return;
        }
        if (bl) {
            this.removePassword(string, string2);
        } else {
            this.process(string, string2);
        }
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string)));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    private void removePassword(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.endsWith(".data.db")) continue;
            this.removePassword(string3);
        }
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    private void removePassword(String string) throws SQLException {
        this.setDatabaseName(string.substring(string.length() - ".data.db".length()));
        this.textStorage = Database.isTextStorage(string, false);
        byte[] byArray = Database.getMagic(this.textStorage);
        FileStore fileStore = FileStore.open(null, string, "rw", byArray);
        long l = fileStore.length();
        int n = 48;
        int n2 = 128;
        int n3 = (int)(l / (long)n2);
        this.blockCount = 1;
        for (int i = 0; i < n3; i += this.blockCount) {
            Value[] valueArray;
            fileStore.seek((long)n + (long)i * (long)n2);
            byte[] byArray2 = new byte[n2];
            DataPage dataPage = DataPage.create((DataHandler)this, byArray2);
            long l2 = fileStore.getFilePointer();
            fileStore.readFully(byArray2, 0, n2);
            this.blockCount = dataPage.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                dataPage.checkCapacity(this.blockCount * n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
            }
            try {
                dataPage.check(this.blockCount * n2);
            }
            catch (SQLException sQLException) {
                this.blockCount = 1;
                continue;
            }
            this.storageId = dataPage.readInt();
            if (this.storageId != 0) continue;
            this.recordLength = dataPage.readInt();
            if (this.recordLength <= 0) continue;
            try {
                valueArray = new Value[this.recordLength];
            }
            catch (Throwable throwable) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    valueArray[this.valueId] = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int n4;
                String string2 = valueArray[3].getString();
                if (!string2.startsWith("CREATE USER ") || (n4 = string2.indexOf("SALT")) < 0) continue;
                String string3 = string2.substring("CREATE USER ".length(), n4 - 1);
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                SHA256 sHA256 = new SHA256();
                byte[] byArray3 = sHA256.getKeyPasswordHash(string3, "".toCharArray());
                byte[] byArray4 = RandomUtils.getSecureBytes(8);
                byte[] byArray5 = sHA256.getHashWithSalt(byArray3, byArray4);
                boolean bl = string2.indexOf("ADMIN") >= 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE USER ");
                stringBuffer.append(Parser.quoteIdentifier(string3));
                stringBuffer.append(" SALT '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray4));
                stringBuffer.append("' HASH '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray5));
                stringBuffer.append("'");
                if (bl) {
                    stringBuffer.append(" ADMIN");
                }
                byte[] byArray6 = stringBuffer.toString().getBytes();
                int n5 = ByteUtils.indexOf(dataPage.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(byArray6, 0, dataPage.getBytes(), n5, byArray6.length);
                dataPage.fill(this.blockCount * n2);
                dataPage.updateChecksum();
                fileStore.seek(l2);
                fileStore.write(dataPage.getBytes(), 0, dataPage.length());
                if (!this.trace) break;
                this.out.println("User: " + string3);
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.out);
            }
        }
        this.closeSilently(fileStore);
    }

    public static void execute(String string, String string2) throws SQLException {
        new Recover().process(string, string2);
    }

    private void process(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.endsWith(".data.db")) {
                this.dumpData(string3);
                continue;
            }
            if (string3.endsWith(".index.db")) {
                this.dumpIndex(string3);
                continue;
            }
            if (string3.endsWith(".log.db")) {
                this.dumpLog(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) throws SQLException {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(FileUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray, int n) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " block:" + this.block + " blockCount:" + this.blockCount + " storageId:" + this.storageId + " recordLength: " + this.recordLength + " valueId:" + this.valueId);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('?');
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuffer.append(' ');
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = FileUtils.openFileOutputStream(string2, false);
            this.textStorage = Database.isTextStorage(string, false);
            byte[] byArray = Database.getMagic(this.textStorage);
            fileStore = FileStore.open(null, string, "r", byArray);
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray2 = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray2)) >= 0) {
                outputStream.write(byArray2, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                if (this.trace) {
                    this.traceError(string, throwable);
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                FileUtils.delete(string2);
            }
            catch (SQLException sQLException) {
                this.traceError(string2, sQLException);
            }
        }
    }

    private void writeLogRecord(PrintWriter printWriter, DataPage dataPage) {
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return;
        }
        try {
            Value[] valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//     data: ");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                Value value;
                valueArray[this.valueId] = value = dataPage.readValue();
                if (this.valueId > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getSQL(value));
            }
            catch (Exception exception) {
                if (this.trace) {
                    this.traceError("log data", exception);
                }
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        printWriter.println(stringBuffer.toString());
        printWriter.flush();
    }

    private String getSQL(Value value) {
        ValueLob valueLob;
        byte[] byArray;
        if (value instanceof ValueLob && (byArray = (valueLob = (ValueLob)value).getSmall()) == null) {
            String string = valueLob.getFileName();
            if (valueLob.getType() == 15) {
                return "READ_BLOB('" + string + ".txt')";
            }
            return "READ_CLOB('" + string + ".txt')";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
        this.lobFilesInDirectories = FileUtils.exists(this.databaseName + ".lobs.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(String string) {
        block22: {
            int n;
            DataPage dataPage;
            byte[] byArray;
            int n2;
            int n3;
            int n4;
            long l;
            FileStore fileStore;
            PrintWriter printWriter;
            block21: {
                printWriter = null;
                fileStore = null;
                this.setDatabaseName(string.substring(string.length() - ".log.db".length()));
                printWriter = this.getWriter(string, ".txt");
                this.textStorage = Database.isTextStorage(string, false);
                byte[] byArray2 = Database.getMagic(this.textStorage);
                fileStore = FileStore.open(null, string, "r", byArray2);
                l = fileStore.length();
                printWriter.println("// length: " + l);
                n4 = 48;
                n3 = 16;
                n2 = (int)(l / (long)n3);
                byArray = new byte[n3];
                dataPage = DataPage.create((DataHandler)this, byArray);
                dataPage.fill(3 * n3);
                n = dataPage.length();
                dataPage.reset();
                if (l >= (long)(48 + n)) break block21;
                printWriter.println("// empty file");
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                return;
            }
            try {
                int n5;
                fileStore.seek(n4);
                fileStore.readFully(dataPage.getBytes(), 0, n);
                int n6 = dataPage.readInt();
                int n7 = dataPage.readInt();
                int n8 = dataPage.readInt();
                printWriter.println("// id:" + n6);
                printWriter.println("// firstUncommittedPos:" + n7);
                printWriter.println("// firstUnwrittenPos:" + n8);
                int n9 = (int)(l / (long)n3);
                printWriter.println("// max:" + n9);
                block14: while ((long)(n5 = (int)(fileStore.getFilePointer() / (long)n3)) * (long)n3 < l) {
                    byArray = new byte[n3];
                    fileStore.readFully(byArray, 0, n3);
                    dataPage = DataPage.create((DataHandler)this, byArray);
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 > 1) {
                        byte[] byArray3 = ByteUtils.newBytes(n2 * n3);
                        System.arraycopy(byArray, 0, byArray3, 0, n3);
                        byArray = byArray3;
                        try {
                            fileStore.readFully(byArray, n3, n2 * n3 - n3);
                        }
                        catch (SQLException sQLException) {
                            break;
                        }
                        dataPage = DataPage.create((DataHandler)this, byArray);
                        dataPage.check(n2 * n3);
                    }
                    dataPage.reset();
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 == 0) {
                        printWriter.println("// [" + n5 + "] blocks: " + n2 + " (end)");
                        break;
                    }
                    char c = (char)dataPage.readByte();
                    int n10 = dataPage.readInt();
                    if (c == 'P') {
                        String string2 = dataPage.readString();
                        printWriter.println("//   prepared session:" + n10 + " tx:" + string2);
                        continue;
                    }
                    if (c == 'C') {
                        printWriter.println("//   commit session:" + n10);
                        continue;
                    }
                    int n11 = dataPage.readInt();
                    int n12 = dataPage.readInt();
                    int n13 = dataPage.readInt();
                    if (c != 'T') {
                        dataPage.readDataPageNoSize();
                    }
                    switch (c) {
                        case 'S': {
                            char c2 = (char)dataPage.readByte();
                            int n14 = dataPage.readInt();
                            byte[] byArray4 = ByteUtils.newBytes(n14);
                            if (n14 > 0) {
                                dataPage.read(byArray4, 0, n14);
                            }
                            printWriter.println("//   summary session:" + n10 + " fileType:" + c2 + " sumLength:" + n14);
                            this.dumpSummary(printWriter, byArray4);
                            continue block14;
                        }
                        case 'T': {
                            printWriter.println("//   truncate session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            continue block14;
                        }
                        case 'I': {
                            printWriter.println("//   insert session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                        case 'D': {
                            printWriter.println("//   delete session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                    }
                    printWriter.println("//   type?:" + c + " session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                }
                printWriter.close();
            }
            catch (Throwable throwable) {
                try {
                    this.writeError(printWriter, throwable);
                    break block22;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtils.closeSilently(printWriter);
                    this.closeSilently(fileStore);
                }
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
    }

    private void dumpSummary(PrintWriter printWriter, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            printWriter.println("//     summary is empty");
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < n4 / 8; ++n3) {
                n2 = dataInputStream.read();
                if (n3 % 8 == 0) {
                    printWriter.print("//  ");
                }
                printWriter.print(" " + Long.toString(n3 * 8) + ":");
                for (n = 0; n < 8; ++n) {
                    printWriter.print((n2 & 1) == 1 ? "1" : "0");
                    n2 >>>= 1;
                }
                if (n3 % 8 != 7) continue;
                printWriter.println("");
            }
            printWriter.println("//");
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readInt();
                if (n == -1) continue;
                printWriter.println("//     pos:" + n2 * 64 + " storage:" + n);
            }
            while ((n2 = dataInputStream.readInt()) >= 0) {
                n = dataInputStream.readInt();
                printWriter.println("//     storage:" + n2 + " recordCount:" + n);
            }
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndex(String string) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            this.setDatabaseName(string.substring(string.length() - ".index.db".length()));
            printWriter = this.getWriter(string, ".txt");
            this.textStorage = Database.isTextStorage(string, false);
            byte[] byArray = Database.getMagic(this.textStorage);
            fileStore = FileStore.open(null, string, "r", byArray);
            long l = fileStore.length();
            int n = 48;
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (this.block < n3) {
                block21: {
                    fileStore.seek((long)n + (long)this.block * (long)n2);
                    byte[] byArray2 = new byte[n2];
                    DataPage dataPage = DataPage.create((DataHandler)this, byArray2);
                    fileStore.readFully(byArray2, 0, n2);
                    this.blockCount = dataPage.readInt();
                    this.storageId = -1;
                    this.recordLength = -1;
                    this.valueId = -1;
                    if (this.blockCount == 0) {
                        this.blockCount = 1;
                    } else if (this.blockCount < 0) {
                        this.writeDataError(printWriter, "blockCount<0", dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else if ((long)this.blockCount * (long)n2 >= 0x1FFFFFFFL) {
                        this.writeDataError(printWriter, "blockCount=" + this.blockCount, dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            dataPage.checkCapacity(this.blockCount * n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        if (this.blockCount > 1) {
                            fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
                        }
                        try {
                            dataPage.check(this.blockCount * n2);
                        }
                        catch (SQLException sQLException) {
                            this.writeDataError(printWriter, "wrong checksum", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        this.storageId = dataPage.readInt();
                        if (this.storageId < 0) {
                            this.writeDataError(printWriter, "storageId<0", dataPage.getBytes(), this.blockCount);
                        } else {
                            int n4 = this.block / 64;
                            if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, dataPage.getBytes(), this.blockCount);
                            } else {
                                nArray[n4] = this.storageId;
                            }
                            printWriter.println("// [" + this.block + "] page:" + n4 + " blocks:" + this.blockCount + " storage:" + this.storageId);
                        }
                    }
                }
                this.block += this.blockCount;
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    private void dumpData(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".data.db".length()));
        try {
            this.textStorage = Database.isTextStorage(string, false);
            this.dumpData(string, this.textStorage, string, 48);
        }
        catch (SQLException sQLException) {
            this.traceError("Can not parse file header", sQLException);
            for (int i = 0; i < 256; i += 16) {
                this.textStorage = i % 2 == 0;
                int n = i / 2;
                String string2 = string + (this.textStorage ? ".txt." : ".") + n + ".data.db";
                this.dumpData(string, this.textStorage, string2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpData(String string, boolean bl, String string2, int n) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            printWriter = this.getWriter(string2, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            ObjectArray objectArray = new ObjectArray();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            byte[] byArray = Database.getMagic(bl);
            fileStore = FileStore.open(null, string, "r", byArray);
            long l = fileStore.length();
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (true) {
                block30: {
                    StringBuffer stringBuffer;
                    Value[] valueArray;
                    Object object;
                    block39: {
                        block31: {
                            block38: {
                                block37: {
                                    block35: {
                                        block36: {
                                            block34: {
                                                block33: {
                                                    block32: {
                                                        if (this.block >= n3) break block31;
                                                        fileStore.seek((long)n + (long)this.block * (long)n2);
                                                        byte[] byArray2 = new byte[n2];
                                                        object = DataPage.create((DataHandler)this, byArray2);
                                                        fileStore.readFully(byArray2, 0, n2);
                                                        this.blockCount = ((DataPage)object).readInt();
                                                        this.storageId = -1;
                                                        this.recordLength = -1;
                                                        this.valueId = -1;
                                                        if (this.blockCount != 0) break block32;
                                                        this.blockCount = 1;
                                                        break block30;
                                                    }
                                                    if (this.blockCount >= 0) break block33;
                                                    this.writeDataError(printWriter, "blockCount<0", ((DataPage)object).getBytes(), 1);
                                                    this.blockCount = 1;
                                                    break block30;
                                                }
                                                if ((long)this.blockCount * (long)n2 < 0x1FFFFFFFL && this.blockCount * n2 >= 0) break block34;
                                                this.writeDataError(printWriter, "blockCount=" + this.blockCount, ((DataPage)object).getBytes(), 1);
                                                this.blockCount = 1;
                                                break block30;
                                            }
                                            printWriter.println("-- block " + this.block + " - " + (this.block + this.blockCount - 1));
                                            try {
                                                ((DataPage)object).checkCapacity(this.blockCount * n2);
                                            }
                                            catch (OutOfMemoryError outOfMemoryError) {
                                                this.writeDataError(printWriter, "out of memory", ((DataPage)object).getBytes(), 1);
                                                this.blockCount = 1;
                                                break block30;
                                            }
                                            if (this.blockCount <= 1) break block35;
                                            if (this.blockCount * n2 >= 0) break block36;
                                            this.writeDataError(printWriter, "wrong blockCount", ((DataPage)object).getBytes(), 1);
                                            this.blockCount = 1;
                                            break block30;
                                        }
                                        try {
                                            fileStore.readFully(((DataPage)object).getBytes(), n2, this.blockCount * n2 - n2);
                                        }
                                        catch (Throwable throwable) {
                                            this.writeDataError(printWriter, "eof", ((DataPage)object).getBytes(), 1);
                                            this.blockCount = 1;
                                            fileStore = FileStore.open(null, string, "r", byArray);
                                            break block30;
                                        }
                                    }
                                    try {
                                        ((DataPage)object).check(this.blockCount * n2);
                                    }
                                    catch (SQLException sQLException) {
                                        this.writeDataError(printWriter, "wrong checksum", ((DataPage)object).getBytes(), 1);
                                        this.blockCount = 1;
                                        break block30;
                                    }
                                    this.storageId = ((DataPage)object).readInt();
                                    if (this.storageId >= 0) break block37;
                                    this.writeDataError(printWriter, "storageId<0", ((DataPage)object).getBytes(), this.blockCount);
                                    break block30;
                                }
                                int n4 = this.block / 64;
                                if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                    this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, ((DataPage)object).getBytes(), this.blockCount);
                                } else {
                                    nArray[n4] = this.storageId;
                                }
                                this.recordLength = ((DataPage)object).readInt();
                                if (this.recordLength > 0) break block38;
                                this.writeDataError(printWriter, "recordLength<0", ((DataPage)object).getBytes(), this.blockCount);
                                break block30;
                            }
                            try {
                                valueArray = new Value[this.recordLength];
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                this.writeDataError(printWriter, "out of memory", ((DataPage)object).getBytes(), this.blockCount);
                                break block30;
                            }
                            if (!hashSet.contains(ObjectUtils.getInteger(this.storageId))) {
                                hashSet.add(ObjectUtils.getInteger(this.storageId));
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("CREATE TABLE O_" + this.storageId + "(");
                                for (int i = 0; i < this.recordLength; ++i) {
                                    if (i > 0) {
                                        stringBuffer.append(", ");
                                    }
                                    stringBuffer.append("C");
                                    stringBuffer.append(i);
                                    stringBuffer.append(" VARCHAR");
                                }
                                stringBuffer.append(");");
                                printWriter.println(stringBuffer.toString());
                                printWriter.flush();
                            }
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("INSERT INTO O_" + this.storageId + " VALUES(");
                            this.valueId = 0;
                            break block39;
                        }
                        MetaRecord.sort(objectArray);
                        for (int i = 0; i < objectArray.size(); ++i) {
                            object = (MetaRecord)objectArray.get(i);
                            printWriter.println(((MetaRecord)object).getSQL() + ";");
                        }
                        Iterator iterator = hashMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            Integer n5 = (Integer)object.getKey();
                            valueArray = (Value[])object.getValue();
                            if (!hashSet.contains(n5)) continue;
                            printWriter.println("INSERT INTO " + (String)valueArray + " SELECT * FROM O_" + n5 + ";");
                        }
                        iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            object = (Integer)((Object)iterator.next());
                            printWriter.println("DROP TABLE O_" + object + ";");
                        }
                        printWriter.println("DROP ALIAS READ_CLOB;");
                        printWriter.println("DROP ALIAS READ_BLOB;");
                        printWriter.close();
                        IOUtils.closeSilently(printWriter);
                        this.closeSilently(fileStore);
                        return;
                    }
                    while (this.valueId < this.recordLength) {
                        try {
                            Value value;
                            valueArray[this.valueId] = value = ((DataPage)object).readValue();
                            if (this.valueId > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(this.getSQL(value));
                        }
                        catch (Exception exception) {
                            this.writeDataError(printWriter, "exception " + exception, ((DataPage)object).getBytes(), this.blockCount);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", ((DataPage)object).getBytes(), this.blockCount);
                        }
                        ++this.valueId;
                    }
                    stringBuffer.append(");");
                    printWriter.println(stringBuffer.toString());
                    printWriter.flush();
                    if (this.storageId == 0) {
                        try {
                            SimpleRow simpleRow = new SimpleRow(valueArray);
                            MetaRecord metaRecord = new MetaRecord(simpleRow);
                            objectArray.add(metaRecord);
                            if (metaRecord.getObjectType() == 0) {
                                String string3 = valueArray[3].getString();
                                String string4 = this.extractTableOrViewName(string3);
                                hashMap.put(ObjectUtils.getInteger(metaRecord.getId()), string4);
                            }
                        }
                        catch (Throwable throwable) {
                            this.writeError(printWriter, throwable);
                        }
                    }
                }
                this.block += this.blockCount;
            }
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
            return;
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    public boolean getTextStorage() {
        return this.textStorage;
    }

    public String getDatabasePath() {
        return this.databaseName;
    }

    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        return FileStore.open(this, string, "rw", Constants.MAGIC_FILE_HEADER.getBytes());
    }

    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public void freeUpDiskSpace() {
    }

    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("Invalid Checksum");
    }

    public int compareTypeSave(Value value, Value value2) {
        throw Message.getInternalError();
    }

    public int getMaxLengthInplaceLob() {
        throw Message.getInternalError();
    }

    public int allocateObjectId(boolean bl, boolean bl2) {
        throw Message.getInternalError();
    }

    public String createTempFile() {
        throw Message.getInternalError();
    }

    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    public Trace getTrace() {
        return null;
    }
}

