/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.table.Table;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap grantedRoles;
    private HashMap grantedRights;

    protected RightOwner(Database database, int n, String string, String string2) {
        this.initDbObjectBase(database, n, string, string2);
    }

    public boolean isRoleGranted(Role role) {
        if (role == this) {
            return true;
        }
        if (this.grantedRoles != null) {
            Iterator iterator = this.grantedRoles.keySet().iterator();
            while (iterator.hasNext()) {
                Role role2 = (Role)iterator.next();
                if (role2 == role) {
                    return true;
                }
                if (!role2.isRoleGranted(role)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRightGrantedRecursive(Table table, int n) {
        Right right;
        if (this.grantedRights != null && (right = (Right)this.grantedRights.get(table)) != null && (right.getRightMask() & n) == n) {
            return true;
        }
        if (this.grantedRoles != null) {
            Iterator iterator = this.grantedRoles.keySet().iterator();
            while (iterator.hasNext()) {
                RightOwner rightOwner = (RightOwner)iterator.next();
                if (!rightOwner.isRightGrantedRecursive(table, n)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(Table table, Right right) {
        if (this.grantedRights == null) {
            this.grantedRights = new HashMap();
        }
        this.grantedRights.put(table, right);
    }

    public void revokeRight(Table table) {
        if (this.grantedRights == null) {
            return;
        }
        this.grantedRights.remove(table);
        if (this.grantedRights.size() == 0) {
            this.grantedRights = null;
        }
    }

    public void grantRole(Role role, Right right) {
        if (this.grantedRoles == null) {
            this.grantedRoles = new HashMap();
        }
        this.grantedRoles.put(role, right);
    }

    public void revokeRole(Role role) {
        if (this.grantedRoles == null) {
            return;
        }
        Right right = (Right)this.grantedRoles.get(role);
        if (right == null) {
            return;
        }
        this.grantedRoles.remove(role);
        if (this.grantedRoles.size() == 0) {
            this.grantedRoles = null;
        }
    }

    public Right getRightForTable(Table table) {
        if (this.grantedRights == null) {
            return null;
        }
        return (Right)this.grantedRights.get(table);
    }

    public Right getRightForRole(Role role) {
        if (this.grantedRoles == null) {
            return null;
        }
        return (Right)this.grantedRoles.get(role);
    }
}

