/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.File;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class WCSStorageCleaner
extends TimerTask {
    Logger LOGGER = Logging.getLogger(WCSStorageCleaner.class);
    long expirationDelay;

    public void run() {
        try {
            File temp = GeoserverDataDirectory.findConfigDir((File)GeoserverDataDirectory.getGeoserverDataDirectory(), (String)"temp");
            if (temp == null || !temp.exists()) {
                return;
            }
            File wcsTemp = new File(temp, "wcs");
            if (!wcsTemp.exists()) {
                return;
            }
            long now = System.currentTimeMillis();
            for (File f : wcsTemp.listFiles()) {
                if (now - f.lastModified() <= this.expirationDelay * 1000L) continue;
                f.delete();
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Error occurred while trying to clean up old coverages from temp storage", e);
        }
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }
}

