/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.logging.Logger;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.WCS;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class CoveragesTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)CoveragesTransformer.class.getPackage().getName());
    private static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private WCS wcs;
    private GetCoverageType request;
    private String coverageLocation;

    public CoveragesTransformer(WCS wcs, GetCoverageType request) {
        this(wcs, request, "cid:theCoverage");
    }

    public CoveragesTransformer(WCS wcs, GetCoverageType request, String coverageLocation) {
        this.wcs = wcs;
        this.request = request;
        this.coverageLocation = coverageLocation;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CoveragesTranslator(handler);
    }

    private class CoveragesTranslator
    extends TransformerBase.TranslatorSupport {
        private String proxifiedBaseUrl;

        public CoveragesTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            try {
                if (!(o instanceof CoverageInfo)) {
                    throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
                }
                CoverageInfo info = (CoverageInfo)o;
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", CoveragesTransformer.WCS_URI);
                attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
                attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
                attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
                attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
                String prefixDef = new StringBuffer("xmlns:").append(CoveragesTransformer.XSI_PREFIX).toString();
                attributes.addAttribute("", prefixDef, prefixDef, "", CoveragesTransformer.XSI_URI);
                String locationAtt = new StringBuffer(CoveragesTransformer.XSI_PREFIX).append(":schemaLocation").toString();
                this.proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)CoveragesTransformer.this.request.getBaseUrl(), (String)CoveragesTransformer.this.wcs.getGeoServer().getProxyBaseUrl());
                String locationDef = "http://www.opengis.net/wcs/1.1.1 " + this.proxifiedBaseUrl + "schemas/wcs/1.1.1/wcsCoverages.xsd";
                attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
                this.start("wcs:Coverages", attributes);
                this.handleCoverage(info);
                this.end("wcs:Coverages");
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error occurred during describe coverage xml encoding", e);
            }
        }

        void handleCoverage(CoverageInfo ci) throws Exception {
            this.start("wcs:Coverage");
            this.element("ows:Title", ci.getLabel());
            this.element("ows:Abstract", ci.getDescription());
            this.element("ows:Identifier", ci.getName());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", CoveragesTransformer.this.coverageLocation);
            this.element("ows:Reference", "", attributes);
            this.end("wcs:Coverage");
        }
    }
}

