/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import org.geoserver.data.DataStoreFactoryInitializer;
import org.geoserver.feature.FeatureSourceUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataStoreUtils {
    public static DataStore acquireDataStore(Map params, ServletContext sc) throws IOException {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        return DataStoreUtils.getDataStore(DataStoreUtils.getParams(params, baseDir.getAbsolutePath()));
    }

    public static DataStore getDataStore(Map params) throws IOException {
        DataStoreFactorySpi factory = DataStoreUtils.aquireFactory(params);
        if (factory == null) {
            return null;
        }
        DataStore store = factory.createDataStore(params);
        if (store == null) {
            return null;
        }
        String[] names = store.getTypeNames();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].indexOf(":") < 0) continue;
            return new RetypingDataStore(store);
        }
        return store;
    }

    public static Map getParams(Map m, ServletContext sc) {
        File data_dir = GeoserverDataDirectory.getGeoserverDataDirectory();
        String baseDir = data_dir.getPath();
        return DataStoreUtils.getParams(m, baseDir);
    }

    protected static Map getParams(Map m, String baseDir) {
        return DataStoreInfo.getParams(m, baseDir);
    }

    public static DataStoreFactorySpi aquireFactory(Map params) {
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (!factory.canProcess(params)) continue;
            return factory;
        }
        return null;
    }

    public static DataStoreFactorySpi aquireFactory(String displayName) {
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (factory.getDisplayName().equals(displayName)) {
                return factory;
            }
            if (!factory.getClass().toString().equals(displayName)) continue;
            return factory;
        }
        return null;
    }

    static DataStoreFactorySpi initializeDataStoreFactory(DataStoreFactorySpi factory) {
        List initializers = GeoServerExtensions.extensions(DataStoreFactoryInitializer.class);
        for (DataStoreFactoryInitializer initer : initializers) {
            if (!initer.getFactoryClass().isAssignableFrom(factory.getClass())) continue;
            try {
                initer.initialize(factory);
            }
            catch (Throwable t) {
                String msg = "Error occured processing extension: " + initer.getClass().getName();
                GeoServerExtensions.LOGGER.log(Level.WARNING, msg, t);
            }
        }
        return factory;
    }

    public static DataAccessFactory.Param find(DataStoreFactorySpi factory, String key) {
        return DataStoreUtils.find(factory.getParametersInfo(), key);
    }

    public static DataAccessFactory.Param find(DataAccessFactory.Param[] params, String key) {
        for (int i = 0; i < params.length; ++i) {
            if (!key.equalsIgnoreCase(params[i].key)) continue;
            return params[i];
        }
        return null;
    }

    public static List listDataStoresDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = DataStoreFinder.getAvailableDataStores();
        while (i.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)i.next();
            DataStoreUtils.initializeDataStoreFactory(factory);
            list.add(factory.getDisplayName());
        }
        return list;
    }

    public static Map defaultParams(String description) {
        return DataStoreUtils.defaultParams(DataStoreUtils.aquireFactory(description));
    }

    public static Map defaultParams(DataStoreFactorySpi factory) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        DataAccessFactory.Param[] params = factory.getParametersInfo();
        for (int i = 0; i < params.length; ++i) {
            DataAccessFactory.Param param = params[i];
            String key = param.key;
            String value = null;
            if (param.sample != null) {
                value = param.text(param.sample);
            }
            if (value == null) {
                value = "";
            }
            if (value == null) continue;
            defaults.put(key, value);
        }
        return defaults;
    }

    public static Map toConnectionParams(DataStoreFactorySpi factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        DataAccessFactory.Param[] info = factory.getParametersInfo();
        for (String key : params.keySet()) {
            Object value = DataStoreUtils.find(info, key).lookUp(params);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Envelope getBoundingBoxEnvelope(FeatureSource<SimpleFeatureType, SimpleFeature> fs) throws IOException {
        return FeatureSourceUtils.getBoundingBoxEnvelope(fs);
    }
}

