/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geotools.data.DataStore;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;

public class DataStoreInfo
extends GlobalLayerSupertype {
    org.geoserver.catalog.DataStoreInfo dataStore;
    Catalog catalog;

    public DataStoreInfo(org.geoserver.catalog.DataStoreInfo dataStore, Catalog catalog) {
        this.dataStore = dataStore;
        this.catalog = catalog;
    }

    public void load(DataStoreInfoDTO dto) {
        this.dataStore.getConnectionParameters().clear();
        this.dataStore.getConnectionParameters().putAll(dto.getConnectionParams());
        this.dataStore.setEnabled(dto.isEnabled());
        this.dataStore.setName(dto.getId());
        this.dataStore.setWorkspace(this.catalog.getWorkspaceByName(dto.getNameSpaceId()));
        this.dataStore.setDescription(dto.getTitle());
    }

    Object toDTO() {
        DataStoreInfoDTO dto = new DataStoreInfoDTO();
        dto.setAbstract(this.getAbstract());
        dto.setConnectionParams(this.getParams());
        dto.setEnabled(this.isEnabled());
        dto.setId(this.getId());
        dto.setNameSpaceId(this.getNamesSpacePrefix());
        dto.setTitle(this.getTitle());
        return dto;
    }

    public String getId() {
        return this.dataStore.getName();
    }

    protected Map getParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(this.dataStore.getConnectionParameters());
        params.put("namespace", (Serializable)((Object)this.getNameSpace().getURI()));
        return params;
    }

    public static Map getParams(Map m, String baseDir) {
        Map params = Collections.synchronizedMap(new HashMap(m));
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (key != null && key.matches(".* *url") && value instanceof String) {
                    String path = (String)value;
                    LOGGER.finer("in string url");
                    if (!path.startsWith("file:")) continue;
                    File fixedPath = GeoserverDataDirectory.findDataFile(path);
                    entry.setValue(fixedPath.toURL().toExternalForm());
                    continue;
                }
                if (!(value instanceof URL) || !((URL)value).getProtocol().equals("file")) continue;
                File fixedPath = GeoserverDataDirectory.findDataFile(((URL)value).toString());
                entry.setValue(fixedPath.toURL());
            }
            catch (MalformedURLException ignore) {}
        }
        return params;
    }

    public synchronized DataStore getDataStore() throws IllegalStateException, NoSuchElementException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("this datastore is not enabled, check your configuration");
        }
        try {
            return this.dataStore.getDataStore(null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getTitle() {
        return this.dataStore.getDescription();
    }

    public String getAbstract() {
        return this.dataStore.getDescription();
    }

    public boolean isEnabled() {
        return this.dataStore.isEnabled();
    }

    public NameSpaceInfo getNameSpace() {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(this.dataStore.getWorkspace().getName());
        return new NameSpaceInfo(ns, this.catalog);
    }

    public String getNamesSpacePrefix() {
        return this.dataStore.getWorkspace().getName();
    }

    public String toString() {
        return new StringBuffer("DataStoreConfig[namespace=").append(this.getNameSpace().getPrefix()).append(", enabled=").append(this.isEnabled()).append(", abstract=").append(this.getAbstract()).append(", connection parameters=").append(this.getParams()).append("]").toString();
    }

    public boolean containsMetaData(String key) {
        return this.dataStore.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.dataStore.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.dataStore.getMetadata().get(key);
    }

    public void dispose() {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            ds.dispose();
        }
    }
}

