/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;

public abstract class XStreamServiceLoader
implements ServiceLoader {
    GeoServerResourceLoader resourceLoader;

    public XStreamServiceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceInfo load(GeoServer gs) throws Exception {
        String filename = this.getServiceId() + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file != null && file.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                XStream xstream = new XStream();
                ServiceInfo serviceInfo = (ServiceInfo)xstream.fromXML((InputStream)in);
                return serviceInfo;
            }
            finally {
                in.close();
            }
        }
        return this.createServiceFromScratch(gs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ServiceInfo service, GeoServer gs) throws Exception {
        String filename = this.getServiceId() + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file == null) {
            file = this.resourceLoader.createFile(filename);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XStream xstream = new XStream();
            xstream.toXML((Object)service, (OutputStream)out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    protected abstract ServiceInfo createServiceFromScratch(GeoServer var1);
}

