/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyServicesReader {
    Element serverConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));
        try {
            this.serverConfiguration = ReaderUtils.parse(reader);
        }
        finally {
            reader.close();
        }
    }

    public Map<String, Object> global() throws Exception {
        Element globalElement = ReaderUtils.getChildElement(this.serverConfiguration, "global");
        HashMap<String, Object> global = new HashMap<String, Object>();
        this.value("verbose", globalElement, global, Boolean.class);
        this.value("verboseExceptions", globalElement, global, Boolean.class);
        this.value("charSet", globalElement, global, String.class);
        this.text("updateSequence", globalElement, global, Integer.class, false, 0);
        this.text("log4jConfigFile", globalElement, global, String.class, false, "DEFAULT_LOGGING.properties");
        this.text("logLocation", globalElement, global, String.class, false, "logs/geoserver.log");
        this.value("suppressStdOutLogging", globalElement, global, Boolean.class, false, Boolean.FALSE);
        this.value("maxFeatures", globalElement, global, Integer.class);
        this.value("numDecimals", globalElement, global, Integer.class);
        this.text("onlineResource", globalElement, global, String.class, false, "http://geoserver.org");
        this.text("ProxyBaseUrl", globalElement, global, String.class);
        try {
            this.value("JaiMemoryCapacity", globalElement, global, Integer.class);
            Integer jmc = (Integer)global.get("JaiMemoryCapacity");
            if (jmc != null) {
                double d = (long)jmc.intValue() / Runtime.getRuntime().maxMemory();
                d = d > 1.0 ? 1.0 : d;
                global.put("JaiMemoryCapacity", d);
            }
        }
        catch (Exception e) {
            this.value("JaiMemoryCapacity", globalElement, global, Double.class);
        }
        this.value("JaiMemoryThreshold", globalElement, global, Double.class);
        this.value("JaiTileThreads", globalElement, global, Integer.class);
        this.value("JaiTilePriority", globalElement, global, Integer.class);
        this.value("JaiRecycling", globalElement, global, Boolean.class);
        this.value("ImageIOCache", globalElement, global, Boolean.class);
        this.value("JaiJPEGNative", globalElement, global, Boolean.class);
        this.value("JaiPNGNative", globalElement, global, Boolean.class);
        this.value("JaiMosaicNative", globalElement, global, Boolean.class);
        return global;
    }

    public Map<String, Object> contact() throws Exception {
        Element globalElement = ReaderUtils.getChildElement(this.serverConfiguration, "global");
        HashMap<String, Object> contact = new HashMap<String, Object>();
        Element contactElement = ReaderUtils.getChildElement(globalElement, "ContactInformation");
        if (contactElement != null) {
            Element personPrimaryElement = ReaderUtils.getChildElement(contactElement, "ContactPersonPrimary");
            if (personPrimaryElement != null) {
                this.text("ContactPerson", personPrimaryElement, contact, String.class);
                this.text("ContactOrganization", personPrimaryElement, contact, String.class);
            }
            this.text("ContactPosition", contactElement, contact, String.class);
            Element addressElement = ReaderUtils.getChildElement(contactElement, "ContactAddress");
            if (addressElement != null) {
                this.text("Address", addressElement, contact, String.class);
                this.text("AddressType", addressElement, contact, String.class);
                this.text("City", addressElement, contact, String.class);
                this.text("StateOrProvince", addressElement, contact, String.class);
                this.text("PostCode", addressElement, contact, String.class);
                this.text("Country", addressElement, contact, String.class);
            }
            this.text("ContactVoiceTelephone", contactElement, contact, String.class);
            this.text("ContactFacsimileTelephone", contactElement, contact, String.class);
            this.text("ContactElectronicMailAddress", contactElement, contact, String.class);
        }
        return contact;
    }

    public Map<String, Object> wfs() throws Exception {
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wfsElement = this.service(servicesElement, "WFS");
        Map<String, Object> wfs = this.readService(wfsElement);
        this.value("serviceLevel", wfsElement, wfs, Integer.class);
        this.value("srsXmlStyle", wfsElement, wfs, Boolean.class, false, Boolean.TRUE);
        this.value("featureBounding", wfsElement, wfs, Boolean.class, false, Boolean.FALSE);
        return wfs;
    }

    public Map<String, Object> wms() throws Exception {
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wmsElement = this.service(servicesElement, "WMS");
        Map<String, Object> wms = this.readService(wmsElement);
        this.text("globalWatermarking", wmsElement, wms, Boolean.class, false, Boolean.FALSE);
        this.text("globalWatermarkingURL", wmsElement, wms, String.class, false, null);
        this.text("globalWatermarkingTransparency", wmsElement, wms, Integer.class, false, 0);
        this.text("globalWatermarkingPosition", wmsElement, wms, Integer.class, false, 8);
        this.text("allowInterpolation", wmsElement, wms, String.class, false, "Nearest");
        this.text("svgRenderer", wmsElement, wms, String.class, false, "Batik");
        this.text("svgAntiAlias", wmsElement, wms, Boolean.class, false, Boolean.TRUE);
        this.text("capabilitiesCrsList", wmsElement, wms, String.class, false, null);
        ArrayList baseMaps = new ArrayList();
        Element baseMapGroupsElement = ReaderUtils.getChildElement(wmsElement, "BaseMapGroups");
        if (baseMapGroupsElement != null) {
            Element[] baseMapGroupElements = ReaderUtils.getChildElements(baseMapGroupsElement, "BaseMapGroup");
            for (int i = 0; i < baseMapGroupElements.length; ++i) {
                Element baseMapGroupElement = baseMapGroupElements[i];
                HashMap<String, Object> baseMap = new HashMap<String, Object>();
                baseMap.put("baseMapTitle", ReaderUtils.getAttribute(baseMapGroupElement, "baseMapTitle", true));
                baseMap.put("baseMapLayers", Arrays.asList(ReaderUtils.getChildText(baseMapGroupElement, "baseMapLayers").split(",")));
                String baseMapStyles = ReaderUtils.getChildText(baseMapGroupElement, "baseMapStyles");
                if (baseMapStyles != null && !"".equals(baseMapStyles)) {
                    baseMap.put("baseMapStyles", Arrays.asList(baseMapStyles.split(",")));
                    baseMap.put("rawBaseMapStyles", baseMapStyles);
                } else {
                    baseMap.put("baseMapStyles", Collections.EMPTY_LIST);
                    baseMap.put("rawBaseMapStyles", "");
                }
                Element baseMapEnvelopeElement = ReaderUtils.getChildElement(baseMapGroupElement, "baseMapEnvelope");
                if (baseMapEnvelopeElement != null) {
                    Element[] posElements = ReaderUtils.getChildElements(baseMapEnvelopeElement, "pos");
                    double x1 = Double.parseDouble(posElements[0].getFirstChild().getNodeValue().split(" ")[0]);
                    double y1 = Double.parseDouble(posElements[0].getFirstChild().getNodeValue().split(" ")[1]);
                    double x2 = Double.parseDouble(posElements[1].getFirstChild().getNodeValue().split(" ")[0]);
                    double y2 = Double.parseDouble(posElements[1].getFirstChild().getNodeValue().split(" ")[1]);
                    String srs = ReaderUtils.getAttribute(baseMapEnvelopeElement, "srsName", false);
                    CoordinateReferenceSystem crs = srs != null ? CRS.decode((String)srs) : null;
                    baseMap.put("baseMapEnvelope", new ReferencedEnvelope(x1, x2, y1, y2, crs));
                }
                baseMaps.add(baseMap);
            }
        }
        wms.put("BaseMapGroups", baseMaps);
        return wms;
    }

    public Map<String, Object> wcs() throws Exception {
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wcsElement = this.service(servicesElement, "WCS");
        Map<String, Object> wcs = this.readService(wcsElement);
        return wcs;
    }

    Map<String, Object> readService(Element serviceElement) throws Exception {
        HashMap<String, Object> service = new HashMap<String, Object>();
        service.put("enabled", ReaderUtils.getBooleanAttribute(serviceElement, "enabled", false, true));
        this.text("name", serviceElement, service, String.class);
        this.text("title", serviceElement, service, String.class);
        this.text("abstract", serviceElement, service, String.class);
        Element mlElement = ReaderUtils.getChildElement(serviceElement, "metadataLink");
        if (mlElement != null) {
            HashMap<String, String> metadataLink = new HashMap<String, String>();
            metadataLink.put("about", ReaderUtils.getAttribute(mlElement, "about", false));
            metadataLink.put("type", ReaderUtils.getAttribute(mlElement, "type", false));
            metadataLink.put("metadataType", ReaderUtils.getAttribute(mlElement, "metadataType", false));
            service.put("metadataLink", metadataLink);
        }
        Element keywordsElement = ReaderUtils.getChildElement(serviceElement, "keywords");
        Element[] keywordElements = ReaderUtils.getChildElements(keywordsElement, "keyword");
        ArrayList<String> keywords = new ArrayList<String>();
        if (keywordElements != null) {
            for (int i = 0; i < keywordElements.length; ++i) {
                keywords.add(keywordElements[i].getFirstChild().getTextContent());
            }
        }
        service.put("keywords", keywords);
        this.text("onlineResource", serviceElement, service, String.class);
        this.text("fees", serviceElement, service, String.class);
        this.text("accessConstraints", serviceElement, service, String.class);
        this.text("SchemaBaseUrl", serviceElement, service, String.class, false, "http://schemas.opengis.net");
        this.value("srsXmlStyle", serviceElement, service, Boolean.class);
        this.value("serviceLevel", serviceElement, service, Integer.class);
        this.text("citeConformanceHacks", serviceElement, service, Boolean.class, false, Boolean.FALSE);
        this.text("maintainer", serviceElement, service, String.class);
        return service;
    }

    Element service(Element servicesElement, String id) throws Exception {
        Element[] serviceElements = ReaderUtils.getChildElements(servicesElement, "service");
        for (int i = 0; i < serviceElements.length; ++i) {
            String serviceId = ReaderUtils.getAttribute(serviceElements[i], "type", false);
            if (!id.equals(serviceId)) continue;
            return serviceElements[i];
        }
        throw new Exception("No service element: " + id);
    }

    void value(String parameter, Element element, Map map, Class clazz) throws Exception {
        this.value(parameter, element, map, clazz, false, null);
    }

    <T> void value(String parameter, Element element, Map<String, Object> map, Class<T> clazz, boolean man, T def) throws Exception {
        Element valueElement = ReaderUtils.getChildElement(element, parameter);
        if (valueElement == null) {
            if (man) {
                throw new RuntimeException("No such element: " + parameter);
            }
            map.put(parameter, def);
            return;
        }
        Object value = null;
        value = Boolean.class.equals(clazz) ? Boolean.valueOf(ReaderUtils.getBooleanAttribute(valueElement, "value", true, false)) : (Integer.class.equals(clazz) ? new Integer(ReaderUtils.getIntAttribute(valueElement, "value", true, -1)) : (Double.class.equals(clazz) ? new Double(ReaderUtils.getDoubleAttribute(valueElement, "value", true)) : ReaderUtils.getAttribute(valueElement, "value", true)));
        map.put(parameter, value);
    }

    void text(String parameter, Element element, Map map, Class clazz) throws Exception {
        this.text(parameter, element, map, clazz, false, null);
    }

    <T> void text(String parameter, Element element, Map<String, Object> map, Class<T> clazz, boolean man, T def) throws Exception {
        String text = ReaderUtils.getChildText(element, parameter);
        if (text == null) {
            if (man) {
                throw new RuntimeException("No such element: " + parameter);
            }
            map.put(parameter, def);
            return;
        }
        Object value = text;
        if (text != null) {
            if (Boolean.class.equals(clazz)) {
                value = Boolean.valueOf(text);
            } else if (Integer.class.equals(clazz)) {
                value = Integer.valueOf(text);
            } else if (Double.class.equals(clazz)) {
                value = Double.valueOf(text);
            }
        }
        map.put(parameter, value);
    }
}

