/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerImpl
implements GeoServer {
    GeoServerFactory factory = new GeoServerFactoryImpl();
    GeoServerInfo global;
    Catalog catalog;
    List<ServiceInfo> services = new ArrayList<ServiceInfo>();
    List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();

    @Override
    public GeoServerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(GeoServerFactory factory) {
        this.factory = factory;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public GeoServerInfo getGlobal() {
        if (this.global == null) {
            return null;
        }
        return ModificationProxy.create(this.global, GeoServerInfo.class);
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.global = global;
    }

    @Override
    public void add(ServiceInfo service) {
        if (service.getId() == null) {
            throw new NullPointerException("service id must not be null");
        }
        for (ServiceInfo s : this.services) {
            if (!s.getId().equals(service.getId())) continue;
            throw new IllegalArgumentException("service with id '" + s.getId() + "' already exists");
        }
        service = ModificationProxy.unwrap(service);
        this.services.add(service);
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!clazz.isAssignableFrom(si.getClass())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!id.equals(si.getId())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        for (ServiceInfo si : this.services) {
            if (!name.equals(si.getName())) continue;
            return (T)ModificationProxy.create(si, clazz);
        }
        return null;
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        return new ProxyList(this.services, ServiceInfo.class){

            @Override
            protected <T> T createProxy(T proxyObject, Class<T> proxyInterface) {
                return ModificationProxy.create(proxyObject, proxyInterface);
            }
        };
    }

    @Override
    public void remove(ServiceInfo service) {
        this.services.remove(service);
    }

    @Override
    public void save(GeoServerInfo geoServer) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(geoServer);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleGlobalChange(geoServer, propertyNames, oldValues, newValues);
            }
            catch (Exception e) {}
        }
        proxy.commit();
    }

    @Override
    public void save(ServiceInfo service) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(service);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handleServiceChange(service, propertyNames, oldValues, newValues);
            }
            catch (Exception e) {}
        }
        proxy.commit();
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<ConfigurationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void dispose() {
        this.global.dispose();
        this.catalog.dispose();
        this.services.clear();
        this.listeners.clear();
    }
}

