package net.sourceforge.ganttproject.task.dependency.constraint;

import java.util.Date;

import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTaskRelationship;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskMutator;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.TaskDependency.ActivityBinding;

/**
 * Dependant task finishes not earlier than dependee finishes Created by
 * IntelliJ IDEA. User: bard
 */
public class FinishFinishConstraintImpl extends ConstraintImpl implements
        TaskDependencyConstraint {
    public FinishFinishConstraintImpl() {
        super(GanttTaskRelationship.FF, GanttLanguage.getInstance().getText(
                "finishfinish"));
    }

    public TaskDependencyConstraint.Collision getCollision() {
        TaskDependencyConstraint.Collision result = null;
        Task dependee = getDependency().getDependee();
        Task dependant = getDependency().getDependant();
        Date dependeeEnd = dependee.getEnd().getTime();
        Date dependantEnd = dependant.getEnd().getTime();
        //
        TaskLength lag = getDependency().getLag();
        Date comparisonDate = lag.getValue()==0 ? dependeeEnd : getTaskManager().shift(dependeeEnd, lag);
        boolean isActive = getDependency().getHardness()==TaskDependency.Hardness.RUBBER ? dependantEnd
                .compareTo(comparisonDate) < 0 : dependantEnd
                .compareTo(comparisonDate) != 0;

        Date acceptableEnd = comparisonDate;
        TaskLength negativeDependantDuration = 
        	getTaskManager().createLength(dependant.getDuration().getTimeUnit(), -dependant.getDuration().getValue());
        Date acceptableStart = getTaskManager().shift(acceptableEnd, negativeDependantDuration);
        result = new TaskDependencyConstraint.DefaultCollision(new GanttCalendar(acceptableStart),
                TaskDependencyConstraint.Collision.START_LATER_VARIATION,
                isActive);
        
        return result;
    }

    public ActivityBinding getActivityBinding() {
        TaskActivity[] dependantActivities = getDependency().getDependant()
                .getActivities();
        TaskActivity[] dependeeActivities = getDependency().getDependee()
                .getActivities();
        TaskActivity theDependant = dependantActivities[dependantActivities.length - 1];
        TaskActivity theDependee = dependeeActivities[dependeeActivities.length - 1];
        return new DependencyActivityBindingImpl(theDependant, theDependee,
                new Date[] { theDependant.getEnd(), theDependee.getEnd() });
    }

}
