package net.sourceforge.ganttproject.task;

import java.math.BigDecimal;

/**
 * Added LaboPM
 * @author Charlyz
 *
 */
public class TaskPrice {
	private BigDecimal myPrice;
	private Boolean isAutomatic;
	private Task myTask;
	
	public Boolean isAuto() {
		return isAutomatic;
	}
	public void setIsAuto(boolean isAutomatic) {
		this.isAutomatic = new Boolean(isAutomatic);
	}
	public void setIsAuto(Boolean isAutomatic) {
		this.isAutomatic = isAutomatic;
	}
	public BigDecimal getManualPrice()
	{
		if (myPrice == null)
			return BigDecimal.valueOf(0l);
		else
			return myPrice;
	}
	private BigDecimal calculateResourceCoefficient()
	{
		BigDecimal result = new BigDecimal(0l);
		for (ResourceAssignment ra : myTask.getAssignments())
			result = result.add(
					//Cost
					BigDecimal.valueOf(Math.round(ra.getResource().getCostsPerUnit() * ra.getLoad() / 100))
					);
		return result;
	}
	public BigDecimal getPrice() {
		if (!isAutomatic)
			return myPrice;
		else
		{
			//Automaticaly calculates the price from resource and length
			
			// TODO Grer avec le vrai prix de la tache et des ressources
			return BigDecimal.valueOf(myTask.getDuration().getLength()).multiply(calculateResourceCoefficient());
		}
	}
	public void setPrice(BigDecimal myPrice) {
		this.myPrice = myPrice;
	}
	public Task getTask() {
		return myTask;
	}
	public void setTask(Task myTask) {
		this.myTask = myTask;
	}
	public TaskPrice(Task task)
	{
		myTask = task;
		myPrice = new BigDecimal(0);
		isAutomatic = false;
	}
}
