/*
 * CategoryManager.java
 *
 * Created on 1. M�rz 2007, 10:18
 *
 */

package net.sourceforge.ganttproject.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Manager for handling task categories.
 *
 * @author shofmann <sebastian.hofmann@sourcepark.de>
 */
public class TaskCategoryManager {    
    
    /** available task categories by their identifier */
    private Map<Long, TaskCategory> categories;
    
    /** holds the maximum task category ID */
    private static long maxCategoryId = 0;
    
    /** Creates a new instance of CategoryManager */
    public TaskCategoryManager() {        
        this.categories = new HashMap<Long, TaskCategory>();
    }
    
    /**
     * Resets the manager - removes all categories
     */
    public void reset(){
        this.categories.clear();    //FIXME: remove assigned tasks...?
    }
    
    /**
     * Adds a new category
     * @param taskCategory the new category to add
     */
    public void addCategory(TaskCategory taskCategory){        
        if(taskCategory.getId() == 0){
            taskCategory.setId(getNextTaskCategoryId());
        }
        else if(taskCategory.getId() > maxCategoryId){
            maxCategoryId = taskCategory.getId();
        }
        this.categories.put(taskCategory.getId(), taskCategory);
    }          

    public TaskCategory createCategory() {
    	TaskCategory result = new TaskCategory(this);
    	addCategory(result);
    	return result;
    }
    /**
     * Assignes a task to a category and vice versa
     * @param task the task to assign
     * @param taskCategoryId identifier of the category to assign to
     */
    public void assignTask(Task task, long taskCategoryId){
        TaskCategory cat = this.categories.get(taskCategoryId);
        if(cat != null){
            cat.assignTask(task);
        }
    }
   
    /**
     * Returns the next ID for TaskCategories
     * @return next ID
     */
    private static long getNextTaskCategoryId(){
        return maxCategoryId++;
    }

	public Collection<TaskCategory> getCategories() {
		return Collections.unmodifiableCollection(this.categories.values());
	}

	void deleteCategory(TaskCategory category) {
		this.categories.remove(category.getId());
	}

	public TaskCategory createCategory(long id) {
		TaskCategory result = createCategory();
		result.setId(id);
		return result;
	} 

}





