/*
 * TaskCategory.java
 *
 * Created on 1. M�rz 2007, 10:17
 *
 */

package net.sourceforge.ganttproject.task;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

/**
 * Class representing a category for grouping tasks
 *
 * @author shofmann <sebastian.hofmann@sourcepark.de>
 */
public class TaskCategory implements Comparable{
    
    /** Creates a new instance of TaskCategory */
    TaskCategory(TaskCategoryManager manager) {        
        this.assignedTasks = new HashSet<Task>();
        this.myManager = manager;
    }
    
    private final TaskCategoryManager myManager;
    /**
     * Holds value of property id.
     */
    private long id = 0;
    
    /**
     * Getter for property id.
     * @return Value of property id.
     */
    public long getId() {
        return this.id;
    }
    
    /**
     * Setter for property id.
     * @param id New value of property id.
     */
    public void setId(long id) {
        this.id = id;
    }
    
    /**
     * Holds value of property color.
     */
    private Color color;
    
    /**
     * Getter for property color.
     * @return Value of property color.
     */
    public Color getColor() {
        return this.color;
    }
    
    /**
     * Setter for property color.
     * @param color New value of property color.
     */
    public void setColor(Color color) {
        this.color = color;
    }
    
    /**
     * Holds value of property description.
     */
    private String description;
    
    /**
     * Getter for property description.
     * @return Value of property description.
     */
    public String getDescription() {
        return this.description;
    }
    
    /**
     * Setter for property description.
     * @param description New value of property description.
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * Indicates whether a object equals this object or not
     * @param obj The object to compare
     * @return true if other object equals this object, otherwise false
     */
    @Override
    public boolean equals(Object obj) {
        TaskCategory that = (TaskCategory)obj;
        return this.color.equals(that.getColor())
        && this.description.equals(that.getDescription())
        && this.id == that.id;
    }
    
    @Override
	public int hashCode() {
		return new Long(this.id).hashCode();
	}

	/**
     * Compares this with another object
     * @param o The object to compare with
     * @return a negative integer, zero, or a positive integer as this object is less than, equal to, or greater than the specified object.
     */
    public int compareTo(Object o) {
        TaskCategory that = (TaskCategory)o;
        return this.description.compareTo(that.getDescription());
    }
    
    /**
     * Return a string-representation of this object
     * @return string-representation of this object
     */
    @Override
    public String toString(){
        return this.description;
    }
    
    /**
     * Holds value of property assignedTasks.
     */
    private Set<Task> assignedTasks;
    
    /**
     * Assigns a task to this category an vice versa
     * @param task the task to assign
     */
    protected void assignTask(Task task){
        task.setTaskCategory(this);
        this.assignedTasks.add(task);
    }
    
    /**
     * Assigns a collection of tasks to this category an vice versa
     * @param tasks collection of tasks to assign
     */
    protected void assignTasks(Collection<Task> tasks){
        for (Task task : tasks) {
            assignTask(task);
        }
    }
    
    /**
     * Releases a single task from this category and vice versa
     * @param task the task to release
     */
    protected void releaseTask(Task task){
        task.setTaskCategory(null);
        this.assignedTasks.remove(task);
    }
    
    /**
     * Releases all assigned tasks from this category and vice versa
     */
    protected void releaseAllTasks(){
        for (Task task : this.assignedTasks) {
            releaseTask(task);
        }
    }
    
    /**
     * Indicates whether this category has tasks assigned or not
     * @return true if tasks are assigned or false otherwise
     */
    public boolean hasTasksAssigned(){
        return this.assignedTasks.size() > 0;
    }

	public void delete() {
		releaseAllTasks();
		myManager.deleteCategory(this);
	}
}
