package net.sourceforge.ganttproject.gui.options.model;

public class DefaultStringOption extends GPAbstractOption implements StringOption {

    private String myLockedValue;
    private String myValue;
    
    public DefaultStringOption(String id) {
        this(id, null);
    }
    public DefaultStringOption(String id, String initialValue) {
        super(id);
        myValue = initialValue;
    }

    public void setValue(String value) {
        setValue(value, !isLocked());
    }

    protected void setValue(String value, boolean reset) {
        if (reset) {
            myValue = value;
        }
        ChangeValueEvent event = null;
        if (myValue!=null && myLockedValue!=null) {
        	if (!myValue.equals(myLockedValue)) {
        		event = new ChangeValueEvent(getID(), myLockedValue, value);
        	}
        }
        else if (false==(myValue==null && myLockedValue==null)) {
        	event = new ChangeValueEvent(getID(), myLockedValue, value);
        }
        myLockedValue = value;    	
        if (event!=null) {
        	fireChangeValueEvent(event);
        }
    }
    public String getValue() {
        return myValue;
    }

    public String getUncommitedValue() {
        return myLockedValue;
    }
    
    public void commit() {
        super.commit();
        myValue = myLockedValue;
    }

    
    @Override
    public void lock() {
        myLockedValue = myValue;
        super.lock();
    }

    public String getPersistentValue() {
        return getValue();
    }

    public void loadPersistentValue(String value) {
        setValue(value);
    }
    
    public boolean isChanged() {
        if (isLocked()) {
            if (myValue!=null) {
                return false==myValue.equals(myLockedValue);
            }
            else {
                return myLockedValue!=null;
            }
        }
        return false;
    }    
    
}
