/*
 * TaskCategoryVO.java
 *
 * Created on 7. September 2007, 09:01
 *
 */

package net.sourceforge.ganttproject.gui.options;

import java.awt.Color;

import net.sourceforge.ganttproject.task.TaskCategory;

/**
 * ValueObject containing data of {@see TaskCategory}-objects
 *
 * @author shofmann <sebastian.hofmann@sourcepark.de>
 */
class TaskCategoryVO implements Comparable{
    
    private final TaskCategory myCategory;

	/** Creates a new instance of TaskCategoryVO */
    public TaskCategoryVO() {
    	myCategory = null;
    }

    /**
     * Creates an new Instance
     * @param tc TaskCategory to get values from
     */
    protected TaskCategoryVO(TaskCategory tc){
    	this.myCategory = tc;
        this.id = tc.getId();
        this.color = tc.getColor();
        this.description = tc.getDescription();
        this.tasksAssigned = tc.hasTasksAssigned();
    }
    
    /**
     * Holds value of property id.
     */
    private long id = -1;

    /**
     * Getter for property id.
     * @return Value of property id.
     */
    public long getId() {
        return this.id;
    }

    /**
     * Setter for property id.
     * @param id New value of property id.
     */
    protected void setId(long id) {
        this.id = id;
    }

    /**
     * Holds value of property color.
     */
    private Color color;

    /**
     * Getter for property color.
     * @return Value of property color.
     */
    public Color getColor() {
        return this.color;
    }

    /**
     * Setter for property color.
     * @param color New value of property color.
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * Holds value of property tasksAssigned.
     */
    private boolean tasksAssigned = false;

    /**
     * Getter for property tasksAssigned.
     * @return Value of property tasksAssigned.
     */
    public boolean hasTasksAssigned() {
        return this.tasksAssigned;
    }

    /**
     * Setter for property tasksAssigned.
     * @param tasksAssigned New value of property tasksAssigned.
     */
    protected void setTasksAssigned(boolean tasksAssigned) {
        this.tasksAssigned = tasksAssigned;
    }

    /**
     * Holds value of property description.
     */
    private String description;

    /**
     * Getter for property description.
     * @return Value of property description.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Setter for property description.
     * @param description New value of property description.
     */
    public void setDescription(String description) {
        this.description = description;
    }        

    /**
     * Returns a String-representation of this object
     * @return String-representation of this object
     */
    @Override
    public String toString() {
        return this.description;
    }

    /**
     * Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     */
    public int compareTo(Object o) {
        TaskCategoryVO that = (TaskCategoryVO)o;
        return this.description.compareToIgnoreCase(that.getDescription());
    }

	public TaskCategory getCategory() {
		return this.myCategory;
	}
}
