package net.sourceforge.ganttproject.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.export.TaskHierarchyTreeModel.TaskTreeNode;
import net.sourceforge.ganttproject.gui.TaskSelectionContext;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.UIUtil;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;

public class ContextChooserPage implements WizardPage {
    private JComponent myComponent;
    private JTree myTree;
    private final State myState;
    private final IGanttProject myProject;
    private final UIFacade myUIFacade;
    private Action myExportWholeProjectAction;
    private Action myExportSelectedTasksAction;
    private boolean isTheWholeProjectExported;
    private boolean isFirstTime = true;
    private JRadioButton wholeProject;
    private JRadioButton selectedTasks;

    public ContextChooserPage(State state, IGanttProject project, UIFacade uifacade) {
        myState = state;
        myProject = project;
        myUIFacade = uifacade;
    }

    public Component getComponent() {
        if (myComponent == null) {
            myExportWholeProjectAction = new AbstractAction(i18n("exportWizard.contextChooserPage.wholeProject")) {
                public void actionPerformed(ActionEvent e) {
                    isTheWholeProjectExported = true;
                    updateTaskContext();
                    UIUtil.setEnabledTree(myTree, false);
                }
            };
            myExportSelectedTasksAction = new AbstractAction(i18n("exportWizard.contextChooserPage.selectedTasks")) {
                public void actionPerformed(ActionEvent e) {
                    isTheWholeProjectExported = false;
                    updateTaskContext();
                    UIUtil.setEnabledTree(myTree, true);
                }
            };
            myTree = new JTree(new TaskHierarchyTreeModel(myProject.getTaskContainment()));
            wholeProject = new JRadioButton(myExportWholeProjectAction);
            selectedTasks = new JRadioButton(myExportSelectedTasksAction);
            ButtonGroup exportGroup = new ButtonGroup();
            exportGroup.add(wholeProject);
            exportGroup.add(selectedTasks);
            Box buttonBox = Box.createVerticalBox();
            buttonBox.add(wholeProject);
            buttonBox.add(selectedTasks);

            myComponent = new JPanel(new BorderLayout());
            myComponent.add(buttonBox, BorderLayout.NORTH);
            myComponent.add(myTree, BorderLayout.CENTER);
        }
        return myComponent;
    }

    protected String i18n(String key) {
        return GanttLanguage.getInstance().getText(key);
    }
    public String getTitle() {
        return GanttLanguage.getInstance().getText("exportWizard.taskChooserPage.title");
    }

    public void setActive(boolean b) {
        if (b) {
            TaskSelectionContext taskContext = myUIFacade.getTaskSelectionContext();
            List tasks = myState.getTaskContext().isEmpty() ? 
                    taskContext.getSelectedTasks() :
                        myState.getTaskContext();
                    List paths = new ArrayList();
                    for (int i=0; i<tasks.size(); i++) {
                        List nextPath = new ArrayList();
                        for (TaskHierarchyTreeModel.TaskTreeNode leafNode = 
                            new TaskHierarchyTreeModel.TaskTreeNode(
                                    (Task) tasks.get(i),
                                    myProject.getTaskContainment());
                        leafNode!=null;
                        leafNode = (TaskTreeNode) leafNode.getParent()) {

                            nextPath.add(leafNode);
                        }
                        Collections.reverse(nextPath);
                        paths.add(new TreePath(nextPath.toArray()));
                    }
                    myTree.getSelectionModel().setSelectionPaths((TreePath[]) paths.toArray(new TreePath[0]));
                    if (isFirstTime) {
                        if (tasks.isEmpty()) {
                            myExportWholeProjectAction.actionPerformed(null);
                            wholeProject.setSelected(true);
                        }
                        else {
                            myExportSelectedTasksAction.actionPerformed(null);
                            selectedTasks.setSelected(true);
                        }
                        isFirstTime = false;
                    }
        }
        else {
            updateTaskContext();
        }
    }

    private void updateTaskContext() {
        final TreePath[] selectedPaths = myTree.getSelectionPaths();
        if (isTheWholeProjectExported || selectedPaths==null) {
            myState.setTaskContext(Collections.EMPTY_LIST);
            return;
        }
        List selectedTasks = new ArrayList();
        for (int i=0; i<selectedPaths.length; i++) {
            TaskHierarchyTreeModel.TaskTreeNode lastNode = 
                (TaskTreeNode) selectedPaths[i].getLastPathComponent();
            selectedTasks.add(lastNode.getTask());
        }
        myState.setTaskContext(selectedTasks);		
    }
}
