package net.sourceforge.ganttproject.datafilter.task;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.datafilter.TaskGroupBase;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.gregorian.FramerImpl;

/**
 * Implementation of TaskGroup interface. Filter existing tasks according to Today's Agenda.
 * 
 * Created 20.02.2008
 * 
 * @author Joanna Muras 
 */
public class TodaysAgendaTaskGroup extends TaskGroupBase {
    private final FramerImpl myDayFramer = new FramerImpl(Calendar.DAY_OF_MONTH);
    
    public TodaysAgendaTaskGroup(String name, TaskManager taskManager) {
        super(name, taskManager);
    }

    /**
     * Filter existing tasks according to the groups and save them as myTasks variable.
     */
    protected void filterTasks(List<Task> unfiltered, List<Task> filtered) {               

        for (Task task : unfiltered) {
            if ( includeTaskAccordingToTodaysAgenda(task.getEnd().getTime(), task.getCompletionPercentage()) ) {
                filtered.add(task); 
            }
        }
    }

    /**
     * Check to which end date group task should be added
     * @param taskEnd
     * @param if you want taskCompletion not to be check give taskCompletion<100
     * @return true if right end date group
     */
    private boolean includeTaskAccordingToTodaysAgenda(Date taskEnd, int taskCompletion) {

        /* Set dates */
        final Date today = myDayFramer.adjustLeft(GregorianCalendar.getInstance().getTime());
        final Date tomorrow = myDayFramer.adjustRight(today);

        /* If group name equals incomplete and task end is due to today */
        if (getName().equals("incomplete") && (taskEnd.equals(today) || taskEnd.after(today)) && taskEnd.before(tomorrow) && taskCompletion<100 ) {
            return true;
            /* If group name equals completed and task end is due to today */
        } else if (getName().equals("completed") && (taskEnd.equals(today) || taskEnd.after(today)) && taskEnd.before(tomorrow) && taskCompletion==100 ) {
            return true;
        }
        return false;
    }
}