package net.sourceforge.ganttproject.datafilter.task;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.datafilter.AutoFix;
import net.sourceforge.ganttproject.datafilter.AutoFixCompleted;
import net.sourceforge.ganttproject.datafilter.FilterOptionGroup;
import net.sourceforge.ganttproject.datafilter.TaskGroup;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;


/**
 * Implementation of FilteredTasks interface. Create task groups for Today's Agenda task filter.
 * 
 * Created 20.02.2008
 * 
 * @author Joanna Muras 
 */
public class TodaysAgendaFilteredTasks extends FilteredTasksBase {

    private final List<TodaysAgendaTaskGroup> myTaskGroups = new ArrayList<TodaysAgendaTaskGroup>();
    /** Keep options available for filter */
    private final List<FilterOptionGroup> mySettings = new ArrayList<FilterOptionGroup>();
    /** Keep quick fixes available for filter */
    private final List<AutoFix> myAutoFixList = new ArrayList<AutoFix>();
    
    private TodaysAgendaFilteredTasks(final TaskManager taskManager) {
        super("todaysAgenda");

        /* Create 2 task groups for Today's Agenda - completed, incomplete */
        myTaskGroups.add(new TodaysAgendaTaskGroup("incomplete", taskManager));
        myTaskGroups.add(new TodaysAgendaTaskGroup("completed", taskManager));
        /* Filter tasks according to groups */
        for (TodaysAgendaTaskGroup group : myTaskGroups) {
            group.filterTasks();
        }
    }
    
    /**
     * Create auto fix list for task in filter tree
     */
    public void updateAutoFixList() {
        myAutoFixList.clear();
        for (TaskGroup taskGroup : myTaskGroups) {
            for (Task task: taskGroup.getTasks()) {
                if (taskGroup.getName().equals("incomplete")) {
                    myAutoFixList.add(new AutoFixCompleted(task));
                } 
            }
        }
    }
    
    public List<AutoFix> getAutoFixList() {
        return myAutoFixList;
    }
    
    @Override
    public TaskGroup[] getTaskGroups() {
        return myTaskGroups.toArray(new TaskGroup[0]);
    }
    
    public GPOptionGroup[] getSettings() {
        return mySettings.toArray(new GPOptionGroup[0]);
    }
    
    public static class Factory implements TaskFilterFactory {
        public FilteredTasks createFilter(IGanttProject project) {
            return new TodaysAgendaFilteredTasks(project.getTaskManager());
        }
    }    
}