package net.sourceforge.ganttproject.datafilter.task;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.datafilter.AutoFix;
import net.sourceforge.ganttproject.datafilter.FilterOptionGroup;
import net.sourceforge.ganttproject.datafilter.TaskGroup;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.task.TaskManager;



/**
 * Implementation of FilteredTasks interface. Create task groups for Priority task filter.
 * 
 * Created 12.2007
 * 
 * @author Joanna Muras 
 */
public class PriorityFilteredTasks extends FilteredTasksBase {

    private final List<PriorityTaskGroup> myTaskGroups = new ArrayList<PriorityTaskGroup>();
    /** Keep options available for filter */
    private final List<FilterOptionGroup> mySettings = new ArrayList<FilterOptionGroup>();
    /** Keep quick fixes available for filter */
    private final List<AutoFix> myAutoFixList = new ArrayList<AutoFix>();
    
    private PriorityFilteredTasks(final TaskManager taskManager) {
        super("priority");
        
        /* Create 3 task groups for Priority - high, normal, and low */
        myTaskGroups.add(new PriorityTaskGroup("high", taskManager));
        myTaskGroups.add(new PriorityTaskGroup("medium", taskManager));
        myTaskGroups.add(new PriorityTaskGroup("low", taskManager));
        for (PriorityTaskGroup group : myTaskGroups) {
            group.filterTasks();
        }
    }
    
    /**
     * Create auto fix list for task in filter tree
     */
    public void updateAutoFixList() {}
    
    public List<AutoFix> getAutoFixList() {
        return myAutoFixList;
    }
    
    @Override
    public TaskGroup[] getTaskGroups() {
        return myTaskGroups.toArray(new TaskGroup[0]);
    }
    
    public GPOptionGroup[] getSettings() {
        return mySettings.toArray(new GPOptionGroup[0]);
    }
    
    public static class Factory implements TaskFilterFactory {
        public FilteredTasks createFilter(IGanttProject project) {
            return new PriorityFilteredTasks(project.getTaskManager());
        }
    }
}
