package net.sourceforge.ganttproject.chart.overview;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.BottomUnitLineRendererImpl;
import net.sourceforge.ganttproject.chart.ChartModel;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartRendererBase;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.Renderer;
import net.sourceforge.ganttproject.chart.ChartModelBase.Offset;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer.Line;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer.Rectangle;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnitStack;

public class OverviewRendererImpl extends ChartRendererBase {
    private Date myEndDate;
    private Date myStartDate;
    private Date myHighlightedEndDate;
    private Date myHighlightedStartDate;

    public OverviewRendererImpl(ChartModel model) {
        super(model);
        model.addRenderer(this);
    }
    
    
    /*
    @Override
    public void afterProcessingTimeFrames() {
        TaskLength tillToday = getChartModel().getTaskManager().createLength(getChartModel().getTimeUnitStack().getDefaultTimeUnit(), getChartModel().getStartDate(), myStartDate);
        int pixelsTillToday = toPixels(tillToday);
        //
        TaskLength fromTodayTillEnd = getChartModel().getTaskManager().createLength(getChartModel().getTimeUnitStack().getDefaultTimeUnit(), myStartDate, myEndDate); 
        int pixelsFromTodayTillEnd = toPixels(fromTodayTillEnd);
        Rectangle rectangle = getPrimitiveContainer().createRectangle(pixelsTillToday, 0, pixelsFromTodayTillEnd, getHeight());
        rectangle.setBackgroundColor(Color.CYAN);
        //
        //
        {
            TaskManager taskManager = getChartModel().getTaskManager(); 
            List<Task> milestones = new ArrayList<Task>();
            for (final Task nextTask : taskManager.getTasks()) {
                if (nextTask.isMilestone()) {
                    milestones.add(nextTask);
                }
            }
            if (milestones.size()!=0) {
                int nextY = getChartModel().getChartUIConfiguration().getHeaderHeight();
                final int milestoneHeight = (getHeight()-nextY)/milestones.size()+1;
                for (final Task nextMilestone : milestones) {
                    nextY+=3;
                    TaskLength fromStart_tillMilestone = taskManager.createLength(getTimeUnitStack().getDefaultTimeUnit(), getOverviewStartDate(), nextMilestone.getStart().getTime());
                    int pixels = toPixels(fromStart_tillMilestone);
                    Rectangle milestoneRectangle = getPrimitiveContainer().createRectangle(pixels-1, nextY, milestoneHeight/2, milestoneHeight/2);
                    milestoneRectangle.setBackgroundColor(Color.BLACK);
                    nextY+=milestoneHeight;
                    
                }
            }
        }
        super.afterProcessingTimeFrames();
    }
*/
//    private int toPixels(TaskLength taskLength) {
//        return (int) (getChartModel().getBottomUnitWidth()*taskLength.getLength(getChartModel().getBottomUnit()));
//    }
//    private TimeUnitStack getTimeUnitStack() {
//        return getChartModel().getTimeUnitStack();
//    }
    
    @Override
    public void render() {
        super.render();
        BottomUnitLineRendererImpl bottomUnitLineRenderer = 
            new BottomUnitLineRendererImpl(getChartModel(), getPrimitiveContainer()) {
                @Override
                protected int getLineBottomPosition() {
                    return 20;
                }
                @Override
                protected int getLineHeight() {
                    return 20;
                }
                @Override
                protected int getLineTopPosition() {
                    return 0;
                }
                @Override
                protected int getTextBaselinePosition() {
                    return 17;
                }
                @Override
                protected Iterable<Offset> getOffsets() {
                    return getChartModel().getTopUnitOffsets();
                }
                
            }; 
        bottomUnitLineRenderer.setHeight(getHeight());
        bottomUnitLineRenderer.render();
        
        int highlightStart = -1;
        int highlightEnd = -1;
        for (Offset offset : getChartModel().getBottomUnitOffsets()) {
            if (highlightStart==-1 && offset.getOffsetEnd().compareTo(myStartDate)>=0) {
                highlightStart = offset.getOffsetPixels();
                myHighlightedStartDate = offset.getOffsetEnd();
            }
            if (highlightEnd==-1 && offset.getOffsetEnd().compareTo(myEndDate)>=0) {
                highlightEnd = offset.getOffsetPixels();
                myHighlightedEndDate = offset.getOffsetEnd();
            }
        }
        Rectangle rectangle = getPrimitiveContainer().createRectangle(
                highlightStart, 0, highlightEnd-highlightStart, getHeight());
        rectangle.setBackgroundColor(new Color(0x99ccff));
        Line leftBorder = getPrimitiveContainer().createLine(highlightStart, 0, highlightStart, getHeight());
        leftBorder.setForegroundColor(Color.BLUE);
        
        Line rightBorder = getPrimitiveContainer().createLine(highlightEnd, 0, highlightEnd, getHeight());
        rightBorder.setForegroundColor(Color.BLUE);
        
    }


    private Date getOverviewStartDate() {
        return getChartModel().getStartDate();
    }

    public GraphicPrimitiveContainer paint() {
        return getPrimitiveContainer();
    }
    public void setEndDate(Date endDate) {
        myEndDate = endDate;
    }
    public void setStartDate(Date date) {
        myStartDate = date;
    }


    public Date getHighlightedEndDate() {
        return myHighlightedEndDate;
    }


    public Date getHighlightedStartDate() {
        return myHighlightedStartDate;
    }
    

}
